/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.undergroundvillages.registration;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.PileFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> PILE_HAY_VILLAGE = ModPlacedFeatures.createKey("pile_hay");
    public static final ResourceKey<PlacedFeature> OAK_VILLAGE = ModPlacedFeatures.createKey("oak");
    public static final ResourceKey<PlacedFeature> FLOWER_PLAIN_VILLAGE = ModPlacedFeatures.createKey("flower_plain");

    public static ResourceKey<PlacedFeature> createKey(String path) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (Identifier)Identifier.fromNamespaceAndPath((String)"underground_villages", (String)path));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter holdergetter = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, PILE_HAY_VILLAGE, (Holder)holdergetter.getOrThrow(PileFeatures.PILE_HAY), (List)Lists.newArrayList());
        PlacementUtils.register(context, OAK_VILLAGE, (Holder)holdergetter.getOrThrow(TreeFeatures.OAK), (List)Lists.newArrayList());
        PlacementUtils.register(context, FLOWER_PLAIN_VILLAGE, (Holder)holdergetter.getOrThrow(VegetationFeatures.FLOWER_PLAIN), (List)Lists.newArrayList());
    }
}

