/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.undergroundvillages.registration;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.undergroundvillages.registration.ModPlacedFeatures;
import com.mrbysco.undergroundvillages.registration.ModProcessorLists;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class ModTemplatePools {
    public static final ResourceKey<StructureTemplatePool> UNDERGROUND_START = ModTemplatePools.createKey("village/underground/town_centers");
    public static final ResourceKey<StructureTemplatePool> UNDERGROUND_TERMINATORS_KEY = ModTemplatePools.createKey("village/underground/terminators");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> context) {
        HolderGetter holdergetter = context.lookup(Registries.PLACED_FEATURE);
        Holder.Reference oakVillageHolder = holdergetter.getOrThrow(ModPlacedFeatures.OAK_VILLAGE);
        Holder.Reference flowerPlainHolder = holdergetter.getOrThrow(ModPlacedFeatures.FLOWER_PLAIN_VILLAGE);
        Holder.Reference pileHayHolder = holdergetter.getOrThrow(ModPlacedFeatures.PILE_HAY_VILLAGE);
        HolderGetter processorListHolderGetter = context.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference mossify10Holder = processorListHolderGetter.getOrThrow(ProcessorLists.MOSSIFY_10_PERCENT);
        Holder.Reference mossify20Holder = processorListHolderGetter.getOrThrow(ProcessorLists.MOSSIFY_20_PERCENT);
        Holder.Reference mossify70Holder = processorListHolderGetter.getOrThrow(ProcessorLists.MOSSIFY_70_PERCENT);
        Holder.Reference zombiePlainsHolder = processorListHolderGetter.getOrThrow(ProcessorLists.ZOMBIE_PLAINS);
        Holder.Reference streetCaveHolder = processorListHolderGetter.getOrThrow(ModProcessorLists.STREET_CAVE);
        Holder.Reference farmPlainsHolder = processorListHolderGetter.getOrThrow(ProcessorLists.FARM_PLAINS);
        HolderGetter templateGetter = context.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference emptyPoolHolder = templateGetter.getOrThrow(Pools.EMPTY);
        Holder.Reference terminatorPoolHolder = templateGetter.getOrThrow(UNDERGROUND_TERMINATORS_KEY);
        context.register(UNDERGROUND_START, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/town_centers/fountain_01", (Holder)mossify20Holder), (Object)50), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/town_centers/meeting_point_1", (Holder)mossify20Holder), (Object)50), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/town_centers/meeting_point_2"), (Object)50), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/town_centers/meeting_point_3", (Holder)mossify70Holder), (Object)50), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/town_centers/fountain_01", (Holder)zombiePlainsHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/town_centers/meeting_point_1", (Holder)zombiePlainsHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/town_centers/meeting_point_2", (Holder)zombiePlainsHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/town_centers/meeting_point_3", (Holder)zombiePlainsHolder), (Object)1)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/underground/streets", new StructureTemplatePool((Holder)terminatorPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/corner_01", (Holder)streetCaveHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/corner_02", (Holder)streetCaveHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/corner_03", (Holder)streetCaveHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/straight_01", (Holder)streetCaveHolder), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/straight_02", (Holder)streetCaveHolder), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/straight_03", (Holder)streetCaveHolder), (Object)7), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/straight_04", (Holder)streetCaveHolder), (Object)7), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/straight_05", (Holder)streetCaveHolder), (Object)3), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/straight_06", (Holder)streetCaveHolder), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/crossroad_01", (Holder)streetCaveHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/crossroad_02", (Holder)streetCaveHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/crossroad_03", (Holder)streetCaveHolder), (Object)2), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/crossroad_04", (Holder)streetCaveHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/crossroad_05", (Holder)streetCaveHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/crossroad_06", (Holder)streetCaveHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/streets/turn_01", (Holder)streetCaveHolder), (Object)3)}), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/underground/zombie/streets", new StructureTemplatePool((Holder)terminatorPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/corner_01", (Holder)streetCaveHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/corner_02", (Holder)streetCaveHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/corner_03", (Holder)streetCaveHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/straight_01", (Holder)streetCaveHolder), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/straight_02", (Holder)streetCaveHolder), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/straight_03", (Holder)streetCaveHolder), (Object)7), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/straight_04", (Holder)streetCaveHolder), (Object)7), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/straight_05", (Holder)streetCaveHolder), (Object)3), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/straight_06", (Holder)streetCaveHolder), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/crossroad_01", (Holder)streetCaveHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/crossroad_02", (Holder)streetCaveHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/crossroad_03", (Holder)streetCaveHolder), (Object)2), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/crossroad_04", (Holder)streetCaveHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/crossroad_05", (Holder)streetCaveHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/crossroad_06", (Holder)streetCaveHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/streets/turn_01", (Holder)streetCaveHolder), (Object)3)}), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/underground/houses", new StructureTemplatePool((Holder)terminatorPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_house_1", (Holder)mossify10Holder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_house_2", (Holder)mossify10Holder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_house_3", (Holder)mossify10Holder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_house_4", (Holder)mossify10Holder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_house_5", (Holder)mossify10Holder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_house_6", (Holder)mossify10Holder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_house_7", (Holder)mossify10Holder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_house_8", (Holder)mossify10Holder), (Object)3), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/medium_house_1", (Holder)mossify10Holder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/medium_house_2", (Holder)mossify10Holder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/big_house_1", (Holder)mossify10Holder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/butcher_shop_1", (Holder)mossify10Holder), (Object)2), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/butcher_shop_2", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/tool_smith_1", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/fletcher_house_1", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/shepherds_house_1"), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/armorer_house_1", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/fisher_cottage_1", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/tannery_1", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/cartographer_1", (Holder)mossify10Holder), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/library_1", (Holder)mossify10Holder), (Object)5), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/library_2", (Holder)mossify10Holder), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/masons_house_1", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/weaponsmith_1", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/temple_3", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/temple_4", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/stable_1", (Holder)mossify10Holder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/stable_2"), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/large_farm_1", (Holder)farmPlainsHolder), (Object)4), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_farm_1", (Holder)farmPlainsHolder), (Object)4), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/animal_pen_1"), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/animal_pen_2"), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/animal_pen_3"), (Object)5), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/accessory_1"), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/meeting_point_4", (Holder)mossify70Holder), (Object)3), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/meeting_point_5"), (Object)1), Pair.of((Object)StructurePoolElement.empty(), (Object)10)}), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/underground/zombie/houses", new StructureTemplatePool((Holder)terminatorPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/small_house_1", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/small_house_2", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/small_house_3", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/small_house_4", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/small_house_5", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/small_house_6", (Holder)zombiePlainsHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/small_house_7", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/small_house_8", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/medium_house_1", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/medium_house_2", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/big_house_1", (Holder)zombiePlainsHolder), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/butcher_shop_1", (Holder)zombiePlainsHolder), (Object)2), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/butcher_shop_2", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/tool_smith_1", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/fletcher_house_1", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/shepherds_house_1", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/armorer_house_1", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/fisher_cottage_1", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/tannery_1", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/cartographer_1", (Holder)zombiePlainsHolder), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/library_1", (Holder)zombiePlainsHolder), (Object)3), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/library_2", (Holder)zombiePlainsHolder), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/masons_house_1", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/weaponsmith_1", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/temple_3", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/temple_4", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/stable_1", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/stable_2", (Holder)zombiePlainsHolder), (Object)2), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/large_farm_1", (Holder)zombiePlainsHolder), (Object)4), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/small_farm_1", (Holder)zombiePlainsHolder), (Object)4), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/animal_pen_1", (Holder)zombiePlainsHolder), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/houses/animal_pen_2", (Holder)zombiePlainsHolder), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/animal_pen_3", (Holder)zombiePlainsHolder), (Object)5), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/meeting_point_4", (Holder)zombiePlainsHolder), (Object)3), Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/houses/meeting_point_5", (Holder)zombiePlainsHolder), (Object)1), Pair.of((Object)StructurePoolElement.empty(), (Object)10)}), StructureTemplatePool.Projection.RIGID));
        context.register(UNDERGROUND_TERMINATORS_KEY, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/terminators/terminator_01", (Holder)streetCaveHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/terminators/terminator_02", (Holder)streetCaveHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/terminators/terminator_03", (Holder)streetCaveHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/terminators/terminator_04", (Holder)streetCaveHolder), (Object)1)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/underground/trees", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.feature((Holder)oakVillageHolder), (Object)1)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/underground/decor", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/lamp_1"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.feature((Holder)oakVillageHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.feature((Holder)flowerPlainHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.feature((Holder)pileHayHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.empty(), (Object)2)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/underground/zombie/decor", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/lamp_1", (Holder)zombiePlainsHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.feature((Holder)oakVillageHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.feature((Holder)flowerPlainHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.feature((Holder)pileHayHolder), (Object)1), (Object)Pair.of((Object)StructurePoolElement.empty(), (Object)2)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/underground/villagers", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/villagers/nitwit"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/villagers/baby"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/underground/zombie/villagers", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/villagers/nitwit"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/underground/zombie/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/common/animals", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cows_1"), (Object)7), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/pigs_1"), (Object)7), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/horses_1"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/horses_2"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/horses_3"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/horses_4"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/horses_5"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/sheep_1"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/sheep_2"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.empty(), (Object)5)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/common/sheep", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/sheep_1"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/sheep_2"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/common/cats", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_black"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_british"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_calico"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_persian"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_ragdoll"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_red"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_siamese"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_tabby"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_white"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cat_jellie"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.empty(), (Object)3)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/common/butcher_animals", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/cows_1"), (Object)3), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/pigs_1"), (Object)3), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/sheep_1"), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/animals/sheep_2"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/common/iron_golem", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/iron_golem"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        ModTemplatePools.registerPools(context, "village/common/well_bottoms", new StructureTemplatePool((Holder)emptyPoolHolder, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)"underground_villages:village/common/well_bottom"), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void registerPools(BootstrapContext<StructureTemplatePool> context, String id, StructureTemplatePool pool) {
        context.register(ModTemplatePools.createKey(id), (Object)pool);
    }

    public static ResourceKey<StructureTemplatePool> createKey(String path) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (Identifier)Identifier.fromNamespaceAndPath((String)"underground_villages", (String)path));
    }
}

