/*
 * Decompiled with CFR 0.152.
 */
package gohkenytp.villagersfollowemeraldblocks;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@Mod(value="villagersfollowemeraldblocks")
public class VillagersFollowEmeraldBlocks {
    public VillagersFollowEmeraldBlocks(ModContainer container, IEventBus modEventBus) {
        modEventBus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    public static class FollowPlayerHoldingEmeraldGoal
    extends Goal {
        private final Villager villager;
        private final double speed;
        private final int followRange;
        private Player nearestPlayer;

        public FollowPlayerHoldingEmeraldGoal(Villager villager, double speed, int followRange) {
            this.villager = villager;
            this.speed = speed;
            this.followRange = followRange;
        }

        public boolean canUse() {
            this.nearestPlayer = this.findNearestPlayerHoldingEmerald();
            return this.nearestPlayer != null;
        }

        public void tick() {
            if (this.nearestPlayer != null) {
                this.villager.getNavigation().moveTo((Entity)this.nearestPlayer, this.speed);
            }
        }

        private Player findNearestPlayerHoldingEmerald() {
            return this.villager.level().players().stream().filter(player -> player.distanceTo((Entity)this.villager) <= (float)this.followRange).filter(player -> this.isHoldingEmeraldRelatedBlock((Player)player)).findFirst().orElse(null);
        }

        private boolean isHoldingEmeraldRelatedBlock(Player player) {
            ItemStack heldItem = player.getMainHandItem();
            return heldItem.is(Items.EMERALD_BLOCK) || heldItem.is(Items.EMERALD_ORE) || heldItem.is(Items.DEEPSLATE_EMERALD_ORE);
        }
    }

    @EventBusSubscriber(modid="villagersfollowemeraldblocks")
    public static class Events {
        @SubscribeEvent
        public static void onEntityJoin(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                villager.goalSelector.addGoal(3, (Goal)new FollowPlayerHoldingEmeraldGoal(villager, 0.7, 10));
            }
        }
    }
}

