/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.IntFunction;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.__internal__.IExtraService;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.NonExtendable
public abstract class ProgressData
implements IData {
    public static final Identifier ID = BuiltinDataUtil.rl("progress");
    public static final IData.Type<ProgressData> TYPE = IData.createType(ID);
    public static final Identifier CONFIG_TIME = BuiltinDataUtil.rl("progress.time");
    public static final Identifier CONFIG_BAR_HEIGHT = BuiltinDataUtil.rl("progress.height");
    public static final Identifier CONFIG_REPLACE_ITEMS = BuiltinDataUtil.rl("progress.replace_items");
    protected final ArrayList<ItemStack> input = new ArrayList();
    protected final ArrayList<ItemStack> output = new ArrayList();
    protected @UnknownNullability IntFunction<ItemStack> itemGetter;

    public static ProgressData ratio(float ratio) {
        return IExtraService.INSTANCE.createRatioProgressData(Mth.clamp((float)ratio, (float)0.0f, (float)1.0f));
    }

    public static ProgressData tick(int current, int total) {
        return IExtraService.INSTANCE.createTickProgressData(current, total);
    }

    public ProgressData input(ItemStack stack) {
        this.input.add(stack);
        return this;
    }

    public ProgressData input(ItemStack ... stacks) {
        this.ensureInputSpace(stacks.length);
        Collections.addAll(this.input, stacks);
        return this;
    }

    public ProgressData input(Collection<ItemStack> stacks) {
        this.input.addAll(stacks);
        return this;
    }

    public ProgressData input(int slot) {
        this.assertInventory();
        return this.input(this.itemGetter.apply(slot));
    }

    public ProgressData input(int ... slots) {
        this.assertInventory();
        this.ensureInputSpace(slots.length);
        for (int slot : slots) {
            this.input.add(this.itemGetter.apply(slot));
        }
        return this;
    }

    public ProgressData output(ItemStack stack) {
        this.output.add(stack);
        return this;
    }

    public ProgressData output(ItemStack ... stacks) {
        this.ensureOutputSpace(stacks.length);
        Collections.addAll(this.output, stacks);
        return this;
    }

    public ProgressData output(Collection<ItemStack> stacks) {
        this.output.addAll(stacks);
        return this;
    }

    public ProgressData output(int slot) {
        this.assertInventory();
        return this.output(this.itemGetter.apply(slot));
    }

    public ProgressData output(int ... slots) {
        this.assertInventory();
        this.ensureOutputSpace(slots.length);
        for (int slot : slots) {
            this.output.add(this.itemGetter.apply(slot));
        }
        return this;
    }

    public ProgressData itemGetter(IntFunction<ItemStack> getter) {
        this.itemGetter = getter;
        return this;
    }

    public ProgressData ensureInputSpace(int length) {
        this.ensureSpace(this.input, length);
        return this;
    }

    public ProgressData ensureOutputSpace(int length) {
        this.ensureSpace(this.output, length);
        return this;
    }

    @ApiStatus.Internal
    private void assertInventory() {
        Preconditions.checkState((this.itemGetter != null ? 1 : 0) != 0, (Object)"Call itemGetter() with stack getter first");
    }

    @ApiStatus.Internal
    private void ensureSpace(ArrayList<ItemStack> list, int toAdd) {
        list.ensureCapacity(list.size() + toAdd);
    }
}

