/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.util;

import java.text.DecimalFormat;

public final class WNumbers {
    private static final DecimalFormat SUFFIXED_FORMAT = new DecimalFormat("0.##");
    private static final long[] DECIMALS = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};

    public static String suffix(long value) {
        if (value == Long.MIN_VALUE) {
            return WNumbers.suffix(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + WNumbers.suffix(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        int exponent = -1;
        long divisor = 0L;
        for (long decimal : DECIMALS) {
            if (value < decimal) break;
            ++exponent;
            divisor = decimal;
        }
        double truncated = (double)value / (double)divisor;
        if (truncated >= 100.0) {
            truncated = Math.round(truncated);
        } else if (truncated >= 10.0) {
            truncated = (double)Math.round(truncated * 10.0) / 10.0;
        }
        return SUFFIXED_FORMAT.format(truncated) + "KMGTPE".charAt(exponent);
    }

    private WNumbers() {
    }
}

