/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IJsonConfig;
import org.jspecify.annotations.Nullable;

public class AnnotationCommenter
implements IJsonConfig.Commenter {
    private final Class<?> cls;
    private final Gson gson;
    private final Map<Class<?>, Field[]> fields = new HashMap();
    private final Map<Field, HashSet<String>> possibleFieldNames = new HashMap<Field, HashSet<String>>();

    public AnnotationCommenter(Class<?> cls, Gson gson) {
        this.cls = cls;
        this.gson = gson;
    }

    @Override
    public @Nullable String getComment(List<String> path) {
        IJsonConfig.Comment comment;
        AnnotatedElement element = null;
        if (path.isEmpty()) {
            element = this.cls;
        } else {
            Class<?> parent = this.cls;
            for (String part : path) {
                Field[] fields;
                for (Field field : fields = this.fields.computeIfAbsent(parent, Class::getDeclaredFields)) {
                    HashSet possibleFieldNames = this.possibleFieldNames.computeIfAbsent(field, f -> {
                        HashSet<String> set = new HashSet<String>();
                        set.add(field.getName());
                        set.add(this.gson.fieldNamingStrategy().translateName(field));
                        SerializedName serializedName = field.getAnnotation(SerializedName.class);
                        if (serializedName != null) {
                            set.add(serializedName.value());
                            set.addAll(Arrays.asList(serializedName.alternate()));
                        }
                        return set;
                    });
                    if (!possibleFieldNames.contains(part)) continue;
                    element = field;
                    parent = field.getType();
                }
            }
        }
        if (element != null && (comment = element.getAnnotation(IJsonConfig.Comment.class)) != null) {
            return comment.value();
        }
        return null;
    }
}

