/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mcp.mobius.waila.api.IJsonConfig;
import org.jspecify.annotations.Nullable;

public class CommenterFactories
implements Supplier<Function<List<String>, String>> {
    private final List<Supplier<IJsonConfig.Commenter>> factories;

    public CommenterFactories(List<Supplier<IJsonConfig.Commenter>> factories) {
        this.factories = factories;
    }

    @Override
    public Function<List<String>, @Nullable String> get() {
        List<IJsonConfig.Commenter> commenters = this.factories.stream().map(Supplier::get).toList();
        return path -> {
            StringBuilder builder = null;
            for (IJsonConfig.Commenter commenter : commenters) {
                String comment = commenter.getComment((List<String>)path);
                if (comment == null) continue;
                if (builder == null) {
                    builder = new StringBuilder(comment);
                    continue;
                }
                builder.append('\n').append(comment);
            }
            return builder == null ? null : builder.toString();
        };
    }
}

