/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import mcp.mobius.waila.plugin.PluginInfo;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

public class ConfigEntry<T> {
    public static final Type<Boolean> BOOLEAN = new Type<Boolean>((e, d) -> e.getAsBoolean(), JsonPrimitive::new);
    public static final Type<Integer> INTEGER = new Type<Integer>((e, d) -> e.getAsInt(), JsonPrimitive::new);
    public static final Type<Double> DOUBLE = new Type<Double>((e, d) -> e.getAsDouble(), JsonPrimitive::new);
    public static final Type<String> STRING = new Type<String>((e, d) -> e.getAsString(), JsonPrimitive::new);
    public static final Type<Enum<? extends Enum>> ENUM = new Type<Enum>((e, d) -> Enum.valueOf(d.getDeclaringClass(), e.getAsString()), e -> new JsonPrimitive(e.name()));
    public static final Type<Path> PATH = new Type<Path>((e, d) -> d, e -> JsonNull.INSTANCE);
    private final PluginInfo origin;
    private final Identifier id;
    private final T defaultValue;
    private final T clientOnlyValue;
    private final boolean serverRequired;
    private final boolean merged;
    private final Type<T> type;
    private @Nullable T serverValue;
    private T localValue;

    private ConfigEntry(PluginInfo origin, Identifier id, T defaultValue, T clientOnlyValue, boolean serverRequired, boolean merged, Type<T> type) {
        this.origin = origin;
        this.id = id;
        this.defaultValue = defaultValue;
        this.localValue = defaultValue;
        this.clientOnlyValue = clientOnlyValue;
        this.serverRequired = serverRequired;
        this.merged = merged;
        this.type = type;
    }

    public Type<T> getType() {
        return this.type;
    }

    public PluginInfo getOrigin() {
        return this.origin;
    }

    public Identifier getId() {
        return this.id;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getClientOnlyValue() {
        return this.clientOnlyValue;
    }

    public boolean isServerRequired() {
        return this.serverRequired;
    }

    public T getLocalValue() {
        return this.localValue;
    }

    public @Nullable T getServerValue() {
        return this.serverValue;
    }

    public void setLocalValue(T localValue) {
        this.assertInstance(localValue);
        this.localValue = localValue;
    }

    public void setServerValue(@Nullable T serverValue) {
        if (serverValue != null) {
            this.assertInstance(serverValue);
        }
        this.serverValue = serverValue;
    }

    public T getValue(boolean forceLocal) {
        if (forceLocal) {
            return this.localValue;
        }
        if (this.merged && this.serverValue instanceof Boolean) {
            return (T)Boolean.valueOf(this.serverValue == Boolean.TRUE && this.localValue == Boolean.TRUE);
        }
        return this.serverRequired ? Objects.requireNonNullElse(this.serverValue, this.clientOnlyValue) : this.localValue;
    }

    public boolean blocksClientEdit() {
        if (this.merged && this.serverValue instanceof Boolean) {
            return this.serverValue == Boolean.FALSE;
        }
        return this.serverRequired;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public boolean isSynced() {
        return this.serverRequired || this.merged;
    }

    public ConfigEntry<T> getActual() {
        return this;
    }

    public Alias<T> createAlias(Identifier id) {
        return new Alias<T>(id, this.getActual());
    }

    public boolean isAlias() {
        return false;
    }

    private void assertInstance(T value) {
        Preconditions.checkArgument((value.getClass() == this.defaultValue.getClass() ? 1 : 0) != 0, (Object)("Tried to assign " + String.valueOf(this.defaultValue.getClass()) + " with " + String.valueOf(value.getClass())));
    }

    public static class Type<T> {
        public final BiFunction<JsonElement, T, T> parser;
        public final Function<T, JsonElement> serializer;

        public Type(BiFunction<JsonElement, T, T> parser, Function<T, JsonElement> serializer) {
            this.parser = parser;
            this.serializer = serializer;
        }

        public ConfigEntry<T> create(PluginInfo origin, Identifier id, T defaultValue, T clientOnlyValue, boolean serverRequired, boolean merged) {
            return new ConfigEntry<T>(origin, id, defaultValue, clientOnlyValue, serverRequired, merged, this);
        }
    }

    public static class Alias<T>
    extends ConfigEntry<T> {
        public final ConfigEntry<T> delegate;

        private Alias(Identifier id, ConfigEntry<T> delegate) {
            super(delegate.origin, id, delegate.defaultValue, delegate.clientOnlyValue, delegate.serverRequired, delegate.merged, delegate.type);
            this.delegate = delegate;
        }

        @Override
        public T getServerValue() {
            return this.delegate.getServerValue();
        }

        @Override
        public void setServerValue(@Nullable T serverValue) {
            this.delegate.setServerValue(serverValue);
        }

        @Override
        public T getLocalValue() {
            return this.delegate.getLocalValue();
        }

        @Override
        public void setLocalValue(T localValue) {
            this.delegate.setLocalValue(localValue);
        }

        @Override
        public ConfigEntry<T> getActual() {
            return this.delegate.getActual();
        }

        @Override
        public boolean isAlias() {
            return true;
        }
    }
}

