/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.config.AnnotationCommenter;
import mcp.mobius.waila.config.CommenterFactories;
import mcp.mobius.waila.mcless.config.ConfigIo;
import mcp.mobius.waila.util.CachedSupplier;
import mcp.mobius.waila.util.Log;
import org.jspecify.annotations.Nullable;

public class JsonConfig<T>
implements IJsonConfig<T> {
    public static final Set<JsonConfig<Object>> INSTANCES = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private static final Log LOG = Log.create();
    private static final Gson DEFAULT_GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    private final Path path;
    private final ConfigIo<T> io;
    private final CachedSupplier<T> getter;

    JsonConfig(Path path, Type type, Supplier<T> factory, boolean json5, Supplier<IJsonConfig.Commenter> commenter, Gson gson, int currentVersion, ToIntFunction<T> versionGetter, ObjIntConsumer<T> versionSetter) {
        this.path = path.toAbsolutePath();
        ArrayList<Supplier<IJsonConfig.Commenter>> commenterFactories = new ArrayList<Supplier<IJsonConfig.Commenter>>();
        if (type instanceof Class) {
            Class cls = (Class)type;
            commenterFactories.add(() -> new AnnotationCommenter(cls, gson));
        }
        commenterFactories.add(commenter);
        this.io = new ConfigIo<T>(LOG::warn, LOG::error, json5, new CommenterFactories(commenterFactories), gson, type, factory, currentVersion, versionGetter, versionSetter);
        this.getter = new CachedSupplier<Object>(() -> this.io.read(this.path));
        INSTANCES.add(this);
    }

    public static void reloadAllInstances() {
        INSTANCES.forEach(it -> it.write(it.get(), true));
    }

    private void write(T t, Path path, boolean invalidate) {
        if (this.io.write(path, t) && invalidate) {
            this.invalidate();
        }
    }

    @Override
    public boolean isFileExists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public T get() {
        return this.getter.get();
    }

    @Override
    public void save() {
        this.write(this.get(), false);
    }

    @Override
    public void write(T t, boolean invalidate) {
        this.write(t, this.path, invalidate);
    }

    @Override
    public void invalidate() {
        this.getter.invalidate();
    }

    @Override
    public void backup(@Nullable String cause) {
        if (this.isFileExists()) {
            Path backupPath = Paths.get(String.valueOf(this.path) + "_" + DATE_FORMAT.format(new Date()), new String[0]);
            String msg = "Config " + String.valueOf(this.path.getFileName()) + " is getting backup to " + String.valueOf(backupPath);
            if (cause != null) {
                msg = msg + " because of " + cause;
            }
            LOG.info(msg);
            this.write(this.get(), backupPath, true);
        }
    }

    public static class Builder<T>
    implements IJsonConfig.Builder0<T>,
    IJsonConfig.Builder1<T> {
        final Type type;
        Supplier<Path> path;
        boolean json5;
        Supplier<IJsonConfig.Commenter> commenter;
        Gson gson;
        int currentVersion;
        ToIntFunction<T> versionGetter;
        ObjIntConsumer<T> versionSetter;
        Supplier<T> factory;

        public Builder(Type type) {
            this.type = type;
            this.json5 = false;
            this.commenter = () -> s -> null;
            this.gson = DEFAULT_GSON;
            this.currentVersion = 0;
            this.versionGetter = t -> 0;
            this.versionSetter = (t, v) -> {};
            if (type instanceof Class) {
                Class clazz = (Class)type;
                this.factory = () -> {
                    try {
                        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create new config instance", e);
                    }
                };
            }
        }

        @Override
        public IJsonConfig.Builder1<T> file(File file) {
            this.path = file::toPath;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> file(Path path) {
            this.path = () -> path;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> file(String fileName) {
            this.path = () -> {
                Object path = fileName;
                if (this.json5) {
                    if (!((String)path).endsWith(".json5")) {
                        path = (String)path + ".json5";
                    }
                } else if (!((String)path).endsWith(".json")) {
                    path = (String)path + ".json";
                }
                return Waila.CONFIG_DIR.resolve((String)path);
            };
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> version(int currentVersion, ToIntFunction<T> versionGetter, ObjIntConsumer<T> versionSetter) {
            this.currentVersion = currentVersion;
            this.versionGetter = versionGetter;
            this.versionSetter = versionSetter;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> factory(Supplier<T> factory) {
            this.factory = factory;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> json5() {
            this.json5 = true;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> commenter(Supplier<IJsonConfig.Commenter> commenter) {
            this.commenter = commenter;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> gson(Gson gson) {
            this.gson = gson;
            return this;
        }

        @Override
        public IJsonConfig<T> build() {
            Preconditions.checkNotNull(this.factory, (Object)"Default value factory must not be null");
            return new JsonConfig<T>(this.path.get(), this.type, this.factory, this.json5, this.commenter, this.gson, this.currentVersion, this.versionGetter, this.versionSetter);
        }
    }
}

