/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import java.util.List;
import java.util.Objects;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.access.ClientAccessor;
import mcp.mobius.waila.access.DataWriter;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.hud.InspectComponent;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.gui.hud.TooltipPosition;
import mcp.mobius.waila.network.play.c2s.BlockDataRequestPlayC2SPacket;
import mcp.mobius.waila.network.play.c2s.EntityDataRequestPlayC2SPacket;
import mcp.mobius.waila.registry.PluginAware;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jspecify.annotations.Nullable;

public class ComponentHandler {
    public static void requestBlockData(ClientAccessor accessor) {
        if (!accessor.hasServer) {
            return;
        }
        Registrar registrar = Registrar.get();
        Block block = accessor.getBlock();
        Object blockEntity = accessor.getBlockEntity();
        int rate = WailaClient.CONFIG.get().getGeneral().getRateLimit();
        if (blockEntity == null || !accessor.isTimeElapsed(rate) || !WailaClient.CONFIG.get().getGeneral().isDisplayTooltip()) {
            return;
        }
        if (registrar.blockData.get(block).isEmpty() && registrar.blockData.get(blockEntity).isEmpty()) {
            return;
        }
        accessor.resetTimer();
        accessor.setDataAccess(false);
        DataWriter.CLIENT.reset();
        Player player = accessor.getPlayer();
        for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : registrar.blockDataCtx.get(block)) {
            DataWriter.CLIENT.tryAppend(player, entry.instance(), accessor, PluginConfig.CLIENT, IBlockComponentProvider::appendDataContext);
        }
        for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : registrar.blockDataCtx.get(blockEntity)) {
            DataWriter.CLIENT.tryAppend(player, entry.instance(), accessor, PluginConfig.CLIENT, IBlockComponentProvider::appendDataContext);
        }
        DataWriter.CLIENT.send((PacketSender)PacketSender.c2s(), player);
        PacketSender.c2s().send((CustomPacketPayload)new BlockDataRequestPlayC2SPacket.Payload(accessor.getBlockHitResult()));
        accessor.setDataAccess(true);
    }

    public static void gatherBlock(ClientAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        Block block = accessor.getBlock();
        Object blockEntity = accessor.getBlockEntity();
        ComponentHandler.handleBlock(accessor, tooltip, block, position);
        if (blockEntity != null) {
            ComponentHandler.handleBlock(accessor, tooltip, blockEntity, position);
        }
    }

    private static void handleBlock(ClientAccessor accessor, Tooltip tooltip, Object obj, TooltipPosition position) {
        Registrar registrar = Registrar.get();
        List<IInstanceRegistry.Entry<PluginAware<IBlockComponentProvider>>> providers = registrar.blockComponent.get((Object)position).get(obj);
        for (IInstanceRegistry.Entry<PluginAware<IBlockComponentProvider>> entry : providers) {
            PluginAware<IBlockComponentProvider> origin = entry.instance();
            IBlockComponentProvider provider = origin.instance();
            tooltip.origin = origin;
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.CLIENT);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
            tooltip.origin = null;
        }
    }

    public static void requestEntityData(Entity entity, ClientAccessor accessor) {
        if (!accessor.hasServer) {
            return;
        }
        Registrar registrar = Registrar.get();
        Object trueEntity = accessor.getEntity();
        int rate = WailaClient.CONFIG.get().getGeneral().getRateLimit();
        if (trueEntity == null || !accessor.isTimeElapsed(rate)) {
            return;
        }
        if (registrar.entityData.get(trueEntity).isEmpty()) {
            return;
        }
        accessor.resetTimer();
        accessor.setDataAccess(false);
        DataWriter.CLIENT.reset();
        Player player = accessor.getPlayer();
        for (IInstanceRegistry.Entry<IEntityComponentProvider> entry : registrar.entityDataCtx.get(entity)) {
            DataWriter.CLIENT.tryAppend(player, entry.instance(), accessor, PluginConfig.CLIENT, IEntityComponentProvider::appendDataContext);
        }
        DataWriter.CLIENT.send((PacketSender)PacketSender.c2s(), player);
        PacketSender.c2s().send((CustomPacketPayload)new EntityDataRequestPlayC2SPacket.Payload(entity.getId(), accessor.getEntityHitResult().getLocation()));
        accessor.setDataAccess(true);
    }

    public static void gatherEntity(Entity entity, ClientAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        Registrar registrar = Registrar.get();
        List<IInstanceRegistry.Entry<PluginAware<IEntityComponentProvider>>> providers = registrar.entityComponent.get((Object)position).get(entity);
        for (IInstanceRegistry.Entry<PluginAware<IEntityComponentProvider>> entry : providers) {
            PluginAware<IEntityComponentProvider> origin = entry.instance();
            IEntityComponentProvider provider = origin.instance();
            tooltip.origin = origin;
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.CLIENT);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
            tooltip.origin = null;
        }
    }

    public static ITooltipComponent getIcon(HitResult target) {
        Registrar registrar = Registrar.get();
        ClientAccessor data = ClientAccessor.INSTANCE;
        PluginConfig config = PluginConfig.CLIENT;
        if (target.getType() == HitResult.Type.ENTITY) {
            List<IInstanceRegistry.Entry<PluginAware<IEntityComponentProvider>>> providers = registrar.entityIcon.get(data.getEntity());
            for (IInstanceRegistry.Entry<PluginAware<IEntityComponentProvider>> provider : providers) {
                PluginAware<IEntityComponentProvider> origin = provider.instance();
                ITooltipComponent icon = InspectComponent.maybeWrap(origin.instance().getIcon(data, config), origin, null);
                if (icon == null) continue;
                return icon;
            }
        } else {
            Object blockEntity;
            BlockState state = data.getBlockState();
            if (state.isAir()) {
                return EmptyComponent.INSTANCE;
            }
            ITooltipComponent result = null;
            int priority = 0;
            for (IInstanceRegistry.Entry<PluginAware<IBlockComponentProvider>> provider : registrar.blockIcon.get(state.getBlock())) {
                PluginAware<IBlockComponentProvider> origin = provider.instance();
                ITooltipComponent icon = origin.instance().getIcon(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
                if (icon == null) continue;
                result = InspectComponent.maybeWrap(icon, origin, null);
                priority = provider.priority();
                break;
            }
            if ((blockEntity = data.getBlockEntity()) != null) {
                for (IInstanceRegistry.Entry<PluginAware<IBlockComponentProvider>> provider : registrar.blockIcon.get(blockEntity)) {
                    if (provider.priority() >= priority) break;
                    PluginAware<IBlockComponentProvider> origin = provider.instance();
                    ITooltipComponent icon = origin.instance().getIcon(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
                    if (icon == null) continue;
                    result = InspectComponent.maybeWrap(icon, origin, null);
                    break;
                }
            }
            if (result != null) {
                return result;
            }
        }
        return EmptyComponent.INSTANCE;
    }

    public static @Nullable Entity getOverrideEntity(@Nullable HitResult target) {
        if (target == null || target.getType() != HitResult.Type.ENTITY) {
            return null;
        }
        Registrar registrar = Registrar.get();
        Entity entity = ((EntityHitResult)target).getEntity();
        List<IInstanceRegistry.Entry<IEntityComponentProvider>> overrideProviders = registrar.entityOverride.get(entity);
        for (IInstanceRegistry.Entry<IEntityComponentProvider> provider : overrideProviders) {
            Entity override = provider.instance().getOverride(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            if (override == null) continue;
            return override;
        }
        return entity;
    }

    public static BlockState getOverrideBlock(HitResult target) {
        Registrar registrar = Registrar.get();
        ClientLevel world = Objects.requireNonNull(Minecraft.getInstance().level);
        BlockPos pos = ((BlockHitResult)target).getBlockPos();
        BlockState state = world.getBlockState(pos);
        BlockState override = null;
        int priority = 0;
        List<IInstanceRegistry.Entry<IBlockComponentProvider>> providers = registrar.blockOverride.get(state.getBlock());
        for (IInstanceRegistry.Entry<IBlockComponentProvider> provider : providers) {
            BlockState blockOverride = provider.instance().getOverride(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            if (blockOverride == null) continue;
            override = blockOverride;
            priority = provider.priority();
            break;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        providers = registrar.blockOverride.get(blockEntity);
        for (IInstanceRegistry.Entry<IBlockComponentProvider> provider : providers) {
            if (provider.priority() >= priority) break;
            BlockState beOverride = provider.instance().getOverride(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            if (beOverride == null) continue;
            override = beOverride;
            break;
        }
        return override != null ? override : state;
    }
}

