/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.gui.screen.TabbedScreen;
import mcp.mobius.waila.gui.screen.YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.Resource;

public class CreditsScreen
extends YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen
implements TabbedScreen {
    public static final Component TITLE = Component.translatable((String)"gui.waila.credits");
    private final Screen parent;

    protected CreditsScreen(Screen parent) {
        super(TITLE);
        this.parent = parent;
    }

    @Override
    public Screen getParent() {
        return this.parent;
    }

    @Override
    protected void init() {
        super.init();
        this.initBar(this.width, x$0 -> {
            TabNavigationBar cfr_ignored_0 = (TabNavigationBar)this.addRenderableWidget((GuiEventListener)x$0);
        }, x$0 -> this.setInitialFocus((GuiEventListener)x$0));
        try {
            CreditMap credits = (CreditMap)new Gson().fromJson((Reader)((Resource)this.minecraft.getResourceManager().getResource(Waila.id("credits.json")).orElseThrow()).openAsReader(), CreditMap.class);
            Objects.requireNonNull(this.minecraft.font);
            ListWidget listWidget = new ListWidget(this.minecraft, this.width, this.height - 56, 24, 9 + 6);
            credits.forEach((key, category) -> {
                listWidget.addEntry(new CreditLine(1, List.of(Component.translatable((String)("gui.waila.credits." + key)).withStyle(ChatFormatting.GRAY))));
                for (List chunk : Lists.partition(category.values.stream().map(Component::literal).toList(), (int)category.width)) {
                    listWidget.addEntry(new CreditLine(category.width, chunk));
                }
                listWidget.addEntry(new CreditLine(1, List.of()));
            });
            listWidget.init();
            this.addRenderableWidget((GuiEventListener)listWidget);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addRenderableWidget((GuiEventListener)DisplayUtil.createButton(this.width / 2 - 50, this.height - 25, 100, 20, CommonComponents.GUI_DONE, w -> this.onClose()));
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private static class CreditMap
    extends LinkedHashMap<String, CreditCategory> {
        private CreditMap() {
        }
    }

    private class ListWidget
    extends ContainerObjectSelectionList<CreditLine> {
        private ListWidget(Minecraft client, int width, int height, int top, int itemHeight) {
            super(client, width, height, top, itemHeight);
        }

        private void init() {
            int totalHeight = (this.children().size() - 1) * this.defaultEntryHeight;
            if (totalHeight < this.height) {
                this.addEntryToTop((AbstractSelectionList.Entry)new CreditLine(1, List.of()), (this.height - totalHeight) / 2 - this.getY());
            }
        }

        protected int addEntry(CreditLine entry) {
            return super.addEntry((AbstractSelectionList.Entry)entry);
        }

        public int getRowWidth() {
            return Math.min(this.width - 20, 360);
        }

        protected int scrollBarX() {
            return this.minecraft.getWindow().getGuiScaledWidth() - 5;
        }

        protected void renderListSeparators(GuiGraphics ctx) {
            Identifier texture = this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
            ctx.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX(), this.getBottom(), 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
        }
    }

    private class CreditLine
    extends ContainerObjectSelectionList.Entry<CreditLine> {
        private final int column;
        private final List<MutableComponent> components;

        private CreditLine(int column, List<MutableComponent> components) {
            this.column = column;
            this.components = components;
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public void renderContent(GuiGraphics ctx, int mouseX, int mouseY, boolean hovered, float delta) {
            if (this.components.isEmpty()) {
                return;
            }
            int rowLeft = this.getX();
            int rowTop = this.getY();
            int columnWidth = this.getWidth() / this.column;
            for (int i = 0; i < this.components.size(); ++i) {
                MutableComponent component = this.components.get(i);
                ctx.drawCenteredString(CreditsScreen.this.minecraft.font, (Component)component, rowLeft + columnWidth * i + columnWidth / 2, rowTop + 3, -1);
            }
        }
    }

    private static class CreditCategory {
        int width = 0;
        List<String> values = List.of();

        private CreditCategory() {
        }
    }
}

