/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.theme;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeAccessor;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.api.__internal__.IClientApiService;
import mcp.mobius.waila.api.util.WRenders;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Range;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.jspecify.annotations.Nullable;

public class GradientTheme
implements ITheme {
    public static final IThemeType<GradientTheme> TYPE = IThemeType.of(GradientTheme.class).property("backgroundColor", IntFormat.RGB_HEX, 0xFF0000).property("gradientStart", IntFormat.RGB_HEX, 65280).property("gradientEnd", IntFormat.RGB_HEX, 255).property("borderSize", true).property("borderOffset", true).property("drawCorner", false).property("fontColor", IntFormat.RGB_HEX, 0xA0A0A0).build();
    private int backgroundColor;
    private int gradientStart;
    private int gradientEnd;
    private int borderSize;
    private int borderOffset;
    private boolean drawCorner;
    private int fontColor;

    @Override
    public void processProperties(IThemeAccessor accessor) {
        this.backgroundColor = Mth.clamp((int)this.backgroundColor, (int)0, (int)0xFFFFFF);
        this.gradientStart = Mth.clamp((int)this.gradientStart, (int)0, (int)0xFFFFFF);
        this.gradientEnd = Mth.clamp((int)this.gradientEnd, (int)0, (int)0xFFFFFF);
        this.borderSize = Math.max(this.borderSize, 0);
        this.borderOffset = Math.max(this.borderOffset, 0);
        this.fontColor = Mth.clamp((int)this.fontColor, (int)0, (int)0xFFFFFF);
    }

    @Override
    public int getDefaultTextColor() {
        return this.fontColor;
    }

    @Override
    public void setPadding(ITheme.Padding padding) {
        padding.set(this.borderOffset + this.borderSize + 2);
    }

    @Override
    public void renderTooltipBackground(GuiGraphics ctx, int x, int y, int width, int height, @Range(from=0L, to=255L) int alpha, DeltaTracker delta) {
        WRenders.state(ctx).submitGuiElement((GuiElementRenderState)new RenderState(alpha, new Matrix3x2f((Matrix3x2fc)ctx.pose()), new ScreenRectangle(x, y, width, height)));
    }

    private class RenderState
    implements GuiElementRenderState {
        final int alpha;
        final Matrix3x2f matrix;
        final ScreenRectangle bounds;

        private RenderState(int alpha, Matrix3x2f matrix, ScreenRectangle bounds) {
            this.alpha = alpha;
            this.matrix = matrix;
            this.bounds = bounds;
        }

        public @Nullable ScreenRectangle bounds() {
            return this.bounds;
        }

        public void buildVertices(VertexConsumer buf) {
            int x = this.bounds.left();
            int y = this.bounds.top();
            int width = this.bounds.width();
            int height = this.bounds.height();
            int a = this.alpha << 24;
            int bg = GradientTheme.this.backgroundColor + a;
            int gradStart = GradientTheme.this.gradientStart + a;
            int gradEnd = GradientTheme.this.gradientEnd + a;
            int bo = GradientTheme.this.borderOffset;
            int bo2 = GradientTheme.this.borderOffset * 2;
            if (GradientTheme.this.drawCorner) {
                IClientApiService.INSTANCE.fillGradient(this.matrix, buf, x, y, width, height, bg, bg);
            } else {
                IClientApiService.INSTANCE.fillGradient(this.matrix, buf, x + bo, y, width - bo2, height, bg, bg);
                IClientApiService.INSTANCE.fillGradient(this.matrix, buf, x, y + bo, bo, height - bo2, bg, bg);
                IClientApiService.INSTANCE.fillGradient(this.matrix, buf, x + width - bo, y + bo, bo, height - bo2, bg, bg);
            }
            IClientApiService.INSTANCE.renderRectBorder(this.matrix, buf, x + bo, y + bo, width - bo2, height - bo2, GradientTheme.this.borderSize, gradStart, gradEnd);
        }

        public RenderPipeline pipeline() {
            return RenderPipelines.GUI;
        }

        public TextureSetup textureSetup() {
            return TextureSetup.noTexture();
        }

        public @Nullable ScreenRectangle scissorArea() {
            return null;
        }
    }
}

