/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.animal.panda.Panda;

public enum PandaProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static final Identifier PERSONALITY;
    private static final Identifier TRAITS;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(Options.PANDA_GENES)) {
            return;
        }
        Panda panda = (Panda)accessor.getEntity();
        Panda.Gene personality = panda.getVariant();
        Panda.Gene mainGene = panda.getMainGene();
        Panda.Gene hiddenGene = panda.getHiddenGene();
        tooltip.setLine(PERSONALITY, new PairComponent((Component)Component.translatable((String)"tooltip.waila.panda.personality"), (Component)PandaProvider.geneText(personality)));
        tooltip.setLine(TRAITS, new PairComponent((Component)Component.translatable((String)"tooltip.waila.panda.traits"), (Component)Component.empty().append((Component)PandaProvider.geneText(mainGene)).append(", ").append((Component)PandaProvider.geneText(hiddenGene))));
    }

    private static MutableComponent geneText(Panda.Gene gene) {
        MutableComponent text = Component.translatable((String)("tooltip.waila.panda.gene." + gene.getSerializedName()));
        if (gene.isRecessive()) {
            text.withStyle(ChatFormatting.RED);
        }
        return text;
    }

    static {
        PERSONALITY = Options.PANDA_GENES.withSuffix(".personality");
        TRAITS = Options.PANDA_GENES.withSuffix(".traits");
    }
}

