/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.drawing;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.drawing.db.DrawingDatabase;
import xaeroplus.feature.render.text.Text;
import xaeroplus.util.ChunkUtils;

public class DrawingTextCacheDimensionHandler {
    private final ResourceKey<Level> dimension;
    private int windowRegionX = 0;
    private int windowRegionZ = 0;
    private int windowRegionSize = 0;
    private final DrawingDatabase database;
    private final ListeningExecutorService dbExecutor;
    private final Long2ObjectMap<Text> texts = new Long2ObjectOpenHashMap();
    public final LongSet staleTexts = new LongOpenHashSet();
    Minecraft mc = Minecraft.getInstance();
    ListenableFuture<?> windowMoveFuture = Futures.immediateVoidFuture();

    public DrawingTextCacheDimensionHandler(ResourceKey<Level> dimension, DrawingDatabase database, ListeningExecutorService dbExecutor) {
        this.dimension = dimension;
        this.database = database;
        this.dbExecutor = dbExecutor;
    }

    public void addText(Text text) {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("addText must be called on the main thread");
        }
        long key = ChunkUtils.chunkPosToLong(text.x(), text.z());
        this.texts.put(key, (Object)text);
        this.staleTexts.add(key);
        this.writeStaleTextsToDatabase();
    }

    public void removeText(int x, int z) {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("removeText must be called on the main thread!");
        }
        long key = ChunkUtils.chunkPosToLong(x, z);
        if (this.texts.containsKey(key)) {
            this.texts.remove(key);
            this.staleTexts.add(key);
            this.dbExecutor.execute(() -> this.database.removeText(x, z, this.dimension));
        }
    }

    public Long2ObjectMap<Text> getTexts() {
        return this.texts;
    }

    public synchronized void setWindow(int regionX, int regionZ, int regionSize) {
        boolean windowChanged;
        boolean bl = windowChanged = regionX != this.windowRegionX || regionZ != this.windowRegionZ || regionSize != this.windowRegionSize;
        if (windowChanged && !this.windowMoveFuture.isDone() && (regionX != 0 || regionZ != 0 || regionSize != 0)) {
            XaeroPlus.LOGGER.debug("Rejecting window move to: [{} {} {}] from: [{} {} {}]", new Object[]{regionX, regionZ, regionSize, this.windowRegionX, this.windowRegionZ, this.windowRegionSize});
            return;
        }
        int prevWindowRegionX = this.windowRegionX;
        int prevWindowRegionZ = this.windowRegionZ;
        int prevWindowRegionSize = this.windowRegionSize;
        this.windowRegionX = regionX;
        this.windowRegionZ = regionZ;
        this.windowRegionSize = regionSize;
        if (windowChanged) {
            try {
                this.windowMoveFuture = this.moveWindow0(regionX, regionZ, regionSize, prevWindowRegionX, prevWindowRegionZ, prevWindowRegionSize);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed submitting move window task for {} disk cache dimension: {}", new Object[]{this.database.databaseName, this.dimension.identifier(), e});
            }
        }
    }

    private ListenableFuture<?> moveWindow0(int windowRegionX, int windowRegionZ, int windowRegionSize, int prevWindowRegionX, int prevWindowRegionZ, int prevWindowRegionSize) {
        ListenableFuture loadDataFuture = this.dbExecutor.submit(() -> this.loadTextsFromDatabase(windowRegionX, windowRegionZ, windowRegionSize, prevWindowRegionX, prevWindowRegionZ, prevWindowRegionSize));
        Futures.addCallback((ListenableFuture)loadDataFuture, (FutureCallback)new WindowDataLoadFutureCallback(), (Executor)this.mc);
        ListenableFuture<?> removeDataFuture = this.flushTextsOutsideWindow(windowRegionX, windowRegionZ, windowRegionSize);
        return Futures.allAsList((ListenableFuture[])new ListenableFuture[]{loadDataFuture, removeDataFuture});
    }

    public Long2ObjectMap<Text> loadTextsFromDatabase(int windowRegionX, int windowRegionZ, int windowRegionSize, int prevWindowRegionX, int prevWindowRegionZ, int prevWindowRegionSize) {
        Long2ObjectOpenHashMap texts = new Long2ObjectOpenHashMap();
        this.database.getTextsInWindow(this.dimension, windowRegionX - windowRegionSize, windowRegionX + windowRegionSize, windowRegionZ - windowRegionSize, windowRegionZ + windowRegionSize, arg_0 -> DrawingTextCacheDimensionHandler.lambda$loadTextsFromDatabase$2((Long2ObjectMap)texts, arg_0));
        return texts;
    }

    private ListenableFuture<?> flushTextsOutsideWindow(int windowRegionX, int windowRegionZ, int windowRegionSize) {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("flushTextsOutsideWindow must be called on the main thread");
        }
        Long2ObjectOpenHashMap dataBuf = new Long2ObjectOpenHashMap();
        int blockXMin = ChunkUtils.regionCoordToCoord(windowRegionX - windowRegionSize);
        int blockXMax = ChunkUtils.regionCoordToCoord(windowRegionX + windowRegionSize);
        int blockZMin = ChunkUtils.regionCoordToCoord(windowRegionZ - windowRegionSize);
        int blockZMax = ChunkUtils.regionCoordToCoord(windowRegionZ + windowRegionSize);
        LongIterator it = this.texts.keySet().longIterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            int blockX = ChunkUtils.longToChunkX(key);
            int blockZ = ChunkUtils.longToChunkZ(key);
            if (blockX >= blockXMin && blockX <= blockXMax && blockZ >= blockZMin && blockZ <= blockZMax) continue;
            if (this.staleTexts.contains(key)) {
                dataBuf.put(key, (Object)((Text)this.texts.get(key)));
            }
            it.remove();
        }
        return this.dbExecutor.submit(() -> this.lambda$flushTextsOutsideWindow$3((Long2ObjectMap)dataBuf));
    }

    public Long2ObjectMap<Text> collectStaleTextsToWrite() {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("collectStaleTextsToWrite must be called on the main thread");
        }
        if (this.staleTexts.isEmpty()) {
            return Long2ObjectMaps.emptyMap();
        }
        Long2ObjectOpenHashMap textsToWrite = new Long2ObjectOpenHashMap(this.staleTexts.size());
        LongIterator it = this.staleTexts.longIterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            Text text = (Text)this.texts.get(key);
            if (text != null) {
                textsToWrite.put(key, (Object)text);
            }
            it.remove();
        }
        return textsToWrite;
    }

    public ListenableFuture<?> writeDataToDatabase(Long2ObjectMap<Text> toWrite) {
        try {
            return this.dbExecutor.submit(() -> this.database.insertTextsList(toWrite, this.dimension));
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed to submit db write task for {} disk cache dimension: {}", new Object[]{this.database.databaseName, this.dimension.identifier(), e});
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public ListenableFuture<?> writeStaleTextsToDatabase() {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("writeStaleHighlightsToDatabase must be called on the main thread");
        }
        Long2ObjectMap<Text> toWrite = this.collectStaleTextsToWrite();
        if (toWrite.isEmpty()) {
            return Futures.immediateVoidFuture();
        }
        return this.writeDataToDatabase(toWrite);
    }

    private /* synthetic */ void lambda$flushTextsOutsideWindow$3(Long2ObjectMap dataBuf) {
        this.database.insertTextsList((Long2ObjectMap<Text>)dataBuf, this.dimension);
    }

    private static /* synthetic */ void lambda$loadTextsFromDatabase$2(Long2ObjectMap texts, Text text) {
        texts.put(ChunkUtils.chunkPosToLong(text.x(), text.z()), (Object)text);
    }

    private final class WindowDataLoadFutureCallback
    implements FutureCallback<Long2ObjectMap<Text>> {
        private WindowDataLoadFutureCallback() {
        }

        public void onSuccess(Long2ObjectMap<Text> dataBuf) {
            if (!DrawingTextCacheDimensionHandler.this.mc.isSameThread()) {
                XaeroPlus.LOGGER.error("WindowDataLoadFutureCallback must be called on the main thread");
            }
            if (dataBuf.isEmpty()) {
                return;
            }
            DrawingTextCacheDimensionHandler.this.texts.putAll(dataBuf);
        }

        public void onFailure(Throwable t) {
            XaeroPlus.LOGGER.error("Error while moving window for {} disk cache dimension: {}", new Object[]{DrawingTextCacheDimensionHandler.this.database.databaseName, DrawingTextCacheDimensionHandler.this.dimension.identifier(), t});
        }
    }
}

