/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.concurrent.ThreadLocalRandom;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractChunkHighlightDrawFeature;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.highlight.DirectChunkHighlightProvider;

public class DirectChunkHighlightDrawFeature
extends AbstractChunkHighlightDrawFeature {
    private final String id;
    private final DirectChunkHighlightProvider chunkHighlightProvider;
    private int lastRefreshedHighlightCount = 0;
    private int jitterOffset = ThreadLocalRandom.current().nextInt(0, 100);
    private final int refreshIntervalMs;

    public DirectChunkHighlightDrawFeature(String id, AbstractHighlightVertexBuffer drawBuffer, DirectChunkHighlightProvider chunkHighlightProvider, int refreshIntervalMs) {
        super(drawBuffer);
        this.id = id;
        this.chunkHighlightProvider = chunkHighlightProvider;
        this.refreshIntervalMs = refreshIntervalMs;
    }

    public int color() {
        return this.chunkHighlightProvider.colorSupplier().getAsInt();
    }

    public Long2LongMap chunkHighlights() {
        return this.chunkHighlightProvider.chunkHighlightSupplier().getHighlights(Globals.getCurrentDimensionId());
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void preRender(DrawContext ctx) {
        super.preRender(ctx);
        Long2LongMap highlights = this.chunkHighlights();
        if (System.currentTimeMillis() - this.drawBuffer.lastRefreshed >= (long)this.refreshIntervalMs) {
            boolean refreshRegardlessThreshold;
            boolean highlightCountChanged = this.lastRefreshedHighlightCount != highlights.size();
            boolean bl = refreshRegardlessThreshold = System.currentTimeMillis() - this.drawBuffer.lastRefreshed > 500L + (long)this.jitterOffset;
            if (highlightCountChanged || refreshRegardlessThreshold) {
                this.invalidateCache();
                this.lastRefreshedHighlightCount = highlights.size();
                this.jitterOffset = ThreadLocalRandom.current().nextInt(0, 100);
            }
        }
        this.drawBuffer.preRender(ctx, highlights, this.color());
    }

    @Override
    public void render(DrawContext ctx) {
        this.preRender(ctx);
        this.drawBuffer.render(ctx, this.chunkHighlights(), this.color());
        this.postRender(ctx);
    }
}

