/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.text;

import java.util.Collection;
import java.util.Optional;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.feature.render.text.AbstractTextDrawFeature;
import xaeroplus.feature.render.text.Text;
import xaeroplus.feature.render.text.TextSupplier;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class DirectTextDrawFeature
extends AbstractTextDrawFeature {
    private final TextSupplier textSupplier;
    private final String id;

    public DirectTextDrawFeature(String id, TextSupplier textSupplier) {
        this.id = id;
        this.textSupplier = textSupplier;
    }

    @Override
    public Collection<Text> getTexts() {
        int windowSize;
        int windowZ;
        int windowX;
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
        } else {
            windowX = ChunkUtils.getPlayerRegionX();
            windowZ = ChunkUtils.getPlayerRegionZ();
            windowSize = Math.max(3, Globals.minimapScaleMultiplier);
        }
        return this.textSupplier.getText(windowX, windowZ, windowSize, Globals.getCurrentDimensionId()).values();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void close() {
    }
}

