/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import xaero.lib.common.gui.widget.TooltipInfo;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.extensions.XaeroPlusSettingEntry;
import xaeroplus.settings.SettingHooks;
import xaeroplus.settings.XaeroPlusSetting;

public class BooleanSetting
extends XaeroPlusSetting {
    public static final KeyMapping.Category KEYBIND_CATEGORY = KeyMapping.Category.register((Identifier)Identifier.fromNamespaceAndPath((String)"xaeroplus", (String)"keybindings"));
    private boolean value;
    private BooleanConsumer settingChangeConsumer;

    private BooleanSetting(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, KeyMapping keyBinding, boolean value, BooleanConsumer settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        super(settingName, settingNameTranslationKey, tooltipTranslationKey, keyBinding, visibilitySupplier);
        this.value = value;
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue) {
        return BooleanSetting.create(settingName, settingNameTranslationKey, defaultValue, false);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, boolean keybind) {
        return new BooleanSetting("[XP] " + settingName, settingNameTranslationKey, BooleanSetting.buildTooltipTranslationKey(settingNameTranslationKey), keybind ? new KeyMapping(settingNameTranslationKey, -1, KEYBIND_CATEGORY) : null, defaultValue, null, null);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, BooleanConsumer settingChangeConsumer) {
        return BooleanSetting.create(settingName, settingNameTranslationKey, defaultValue, false, settingChangeConsumer);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, boolean keybind, BooleanConsumer settingChangeConsumer) {
        return new BooleanSetting("[XP] " + settingName, settingNameTranslationKey, BooleanSetting.buildTooltipTranslationKey(settingNameTranslationKey), keybind ? new KeyMapping(settingNameTranslationKey, -1, KEYBIND_CATEGORY) : null, defaultValue, settingChangeConsumer, null);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, BooleanSupplier visibilitySupplier) {
        return BooleanSetting.create(settingName, settingNameTranslationKey, defaultValue, false, visibilitySupplier);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, boolean keybind, BooleanSupplier visibilitySupplier) {
        return new BooleanSetting("[XP] " + settingName, settingNameTranslationKey, BooleanSetting.buildTooltipTranslationKey(settingNameTranslationKey), keybind ? new KeyMapping(settingNameTranslationKey, -1, KEYBIND_CATEGORY) : null, defaultValue, null, visibilitySupplier);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, BooleanConsumer settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        return BooleanSetting.create(settingName, settingNameTranslationKey, defaultValue, false, settingChangeConsumer, visibilitySupplier);
    }

    public static BooleanSetting create(String settingName, String settingNameTranslationKey, boolean defaultValue, boolean keybind, BooleanConsumer settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        return new BooleanSetting("[XP] " + settingName, settingNameTranslationKey, BooleanSetting.buildTooltipTranslationKey(settingNameTranslationKey), keybind ? new KeyMapping(settingNameTranslationKey, -1, KEYBIND_CATEGORY) : null, defaultValue, settingChangeConsumer, visibilitySupplier);
    }

    @Override
    public String getSerializedValue() {
        return Boolean.toString(this.value);
    }

    @Override
    public void deserializeValue(String value) {
        boolean v = Boolean.parseBoolean(value);
        if (v != this.get()) {
            this.setValue(v);
        }
    }

    @Override
    public XaeroPlusSettingEntry<?> toXaeroSettingEntry() {
        return new XaeroPlusSettingEntry<Boolean>(this, (Component)Component.literal((String)this.getTranslatedName()), new TooltipInfo(this.getTooltipTranslationKey()), false, this::get, 0, 1, v -> v == 1, v -> Component.translatable((String)(v != false ? "gui.xaero_on" : "gui.xaero_off")), (v1, v2) -> {
            this.setValue((boolean)v2);
            SettingHooks.saveSettings();
            Minecraft.getInstance().setScreen(Minecraft.getInstance().screen);
        }, this::isVisible);
    }

    public boolean get() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
        if (Objects.nonNull(this.getSettingChangeConsumer())) {
            try {
                this.getSettingChangeConsumer().accept(value);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.warn("Error applying setting change consumer for {}", (Object)this.getSettingName(), (Object)e);
            }
        }
    }

    public Consumer<Boolean> getSettingChangeConsumer() {
        return this.settingChangeConsumer;
    }

    public void setSettingChangeConsumer(BooleanConsumer settingChangeConsumer) {
        this.settingChangeConsumer = settingChangeConsumer;
    }

    @Override
    public void init() {
        if (Objects.nonNull(this.settingChangeConsumer)) {
            this.settingChangeConsumer.accept(this.value);
        }
    }
}

