/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;

public class Wait {
    public static void wait(int seconds) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitMs(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitSpinLoop() {
        try {
            while (true) {
                Thread.sleep(Integer.MAX_VALUE);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean waitUntil(Supplier<Boolean> conditionSupplier, int secondsToWait) {
        return Wait.waitUntil(conditionSupplier, 50, secondsToWait, TimeUnit.SECONDS);
    }

    public static boolean waitUntil(Supplier<Boolean> conditionSupplier, int checkIntervalMs, long timeout, TimeUnit unit) {
        long beforeTime = System.nanoTime();
        while (!conditionSupplier.get().booleanValue() && TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beforeTime) < unit.toMillis(timeout)) {
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException("Wait Interrupted");
            }
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(checkIntervalMs));
        }
        return conditionSupplier.get();
    }

    public static void waitRandomMs(int ms) {
        Wait.waitMs((int)ThreadLocalRandom.current().nextDouble(ms));
    }
}

