/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core;

import com.google.common.collect.Lists;
import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.core.client.DyeColorItemTintSource;
import dev.apexstudios.apexcore.lib.block.Dyeable;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import dev.apexstudios.apexcore.lib.multiblock.SimpleHorizontalDirectionalMultiBlock;
import dev.apexstudios.placementvisualizer.api.BlockItemPlacementEvent;
import java.util.ArrayList;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.state.BlockBreakingRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ExtractLevelRenderStateEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="apexcore", dist={Dist.CLIENT})
public final class ApexCoreClientEntryPoint {
    public ApexCoreClientEntryPoint(IEventBus modBus) {
        modBus.addListener(RegisterColorHandlersEvent.ItemTintSources.class, event -> event.register(ApexCore.identifier("dye_color"), DyeColorItemTintSource.MAP_CODEC));
        NeoForge.EVENT_BUS.addListener(ExtractLevelRenderStateEvent.class, event -> {
            LevelRenderState renderState = event.getRenderState();
            ClientLevel level = event.getLevel();
            this.extractMultiBlockBreakingProgress(level, renderState);
        });
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, BlockItemPlacementEvent.GetDefaultBlockState.class, event -> {
            Block patt0$temp = event.blockState().getBlock();
            if (patt0$temp instanceof Dyeable) {
                Dyeable dyeable = (Dyeable)patt0$temp;
                event.setBlockState(dyeable.setDyedColor(event.blockState(), dyeable.getDyedColorForPlacement(event.placeContext())));
            }
            if (MultiBlock.isMultiBlock(event.blockState()) && event.blockState().hasProperty((Property)SimpleHorizontalDirectionalMultiBlock.FACING)) {
                event.setBlockState((BlockState)event.blockState().setValue((Property)SimpleHorizontalDirectionalMultiBlock.FACING, (Comparable)event.placeContext().getHorizontalDirection().getOpposite()));
            }
        });
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, BlockItemPlacementEvent.CollectAdditionalBlockStates.class, event -> {
            BlockState blockState = event.blockState();
            if (MultiBlock.isMultiBlock(blockState)) {
                int index = MultiBlock.getIndex(blockState);
                MultiBlock.forEachPos(event.placeContext().getClickedPos(), blockState, (otherPos, otherBlockState) -> {
                    if (index != MultiBlock.getIndex(otherBlockState)) {
                        event.with(otherPos, otherBlockState);
                    }
                });
            }
        });
    }

    private void extractMultiBlockBreakingProgress(ClientLevel level, LevelRenderState renderState) {
        ArrayList additionalBreakingStates = Lists.newArrayList();
        for (BlockBreakingRenderState breakingState : renderState.blockBreakingRenderStates) {
            int index = MultiBlock.getIndex(breakingState.blockState);
            MultiBlock.forEachPos(breakingState.blockPos, breakingState.blockState, (otherPos, otherBlockState) -> {
                if (MultiBlock.getIndex(otherBlockState) != index) {
                    additionalBreakingStates.add(new BlockBreakingRenderState(level, otherPos, breakingState.progress));
                }
            });
        }
        renderState.blockBreakingRenderStates.addAll(additionalBreakingStates);
    }
}

