/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data;

import com.mojang.serialization.Lifecycle;
import dev.apexstudios.apexcore.lib.data.ExtendedRegistryBootstrap;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.conditions.ICondition;

public final class ExtendedRegistryBootstrapImpl<TRegistry>
implements ExtendedRegistryBootstrap<TRegistry> {
    private final BootstrapContext<TRegistry> delegate;
    private final ResourceKey<? extends Registry<TRegistry>> registryType;
    private final String modId;
    private final BiConsumer<ResourceKey<TRegistry>, ICondition[]> conditionsConsumer;
    private final HolderGetter<TRegistry> lookup;

    public ExtendedRegistryBootstrapImpl(BootstrapContext<TRegistry> delegate, ResourceKey<? extends Registry<TRegistry>> registryType, String modId, BiConsumer<ResourceKey<TRegistry>, ICondition[]> conditionsConsumer) {
        this.delegate = delegate;
        this.registryType = registryType;
        this.modId = modId;
        this.conditionsConsumer = conditionsConsumer;
        this.lookup = delegate.lookup(registryType);
    }

    @Override
    public Holder.Reference<TRegistry> register(ResourceKey<TRegistry> registryKey, Lifecycle lifecycle, TRegistry value, ICondition ... conditions) {
        if (conditions.length > 0) {
            this.conditionsConsumer.accept(registryKey, conditions);
        }
        return this.delegate.register(registryKey, value, lifecycle);
    }

    @Override
    public Holder.Reference<TRegistry> register(Identifier registryName, Lifecycle lifecycle, TRegistry value, ICondition ... conditions) {
        return this.register(ResourceKey.create(this.registryType, (Identifier)registryName), lifecycle, value, conditions);
    }

    @Override
    public Holder.Reference<TRegistry> register(String identifier, Lifecycle lifecycle, TRegistry value, ICondition ... conditions) {
        return this.register(Identifier.fromNamespaceAndPath((String)this.modId, (String)identifier), lifecycle, value, conditions);
    }

    @Override
    public <TOther> HolderGetter<TOther> lookup(ResourceKey<? extends Registry<? extends TOther>> registryType) {
        return this.delegate.lookup(registryType);
    }

    @Override
    public <TOther> Optional<HolderLookup.RegistryLookup<TOther>> registryLookup(ResourceKey<? extends Registry<? extends TOther>> registryType) {
        return this.delegate.registryLookup(registryType);
    }

    public Optional<Holder.Reference<TRegistry>> get(ResourceKey<TRegistry> registryKey) {
        return this.lookup.get(registryKey);
    }

    public Holder.Reference<TRegistry> getOrThrow(ResourceKey<TRegistry> registryKey) {
        return this.lookup.getOrThrow(registryKey);
    }

    public Optional<HolderSet.Named<TRegistry>> get(TagKey<TRegistry> tag) {
        return this.lookup.get(tag);
    }

    public HolderSet.Named<TRegistry> getOrThrow(TagKey<TRegistry> tag) {
        return this.lookup.getOrThrow(tag);
    }
}

