/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data.provider;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.jetbrains.annotations.Nullable;

public class ItemStackRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final ItemStack result;
    private final Ingredient ingredient;
    private final Map<String, Criterion<?>> criteria = Maps.newLinkedHashMap();
    @Nullable
    private String group = null;
    private final SingleItemRecipe.Factory<?> factory;

    public ItemStackRecipeBuilder(RecipeCategory category, SingleItemRecipe.Factory<?> factory, Ingredient ingredient, ItemStack result) {
        this.category = category;
        this.factory = factory;
        this.ingredient = ingredient;
        this.result = result;
    }

    public ItemStackRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public ItemStackRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceKey<Recipe<?>> registryKey) {
        this.ensureValid(registryKey);
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(registryKey)).rewards(AdvancementRewards.Builder.recipe(registryKey)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        SingleItemRecipe recipe = this.factory.create(Objects.requireNonNullElse(this.group, ""), this.ingredient, this.result);
        output.accept(registryKey, (Recipe)recipe, advancement.build(registryKey.identifier().withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    private void ensureValid(ResourceKey<Recipe<?>> registryKey) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe: " + String.valueOf(registryKey.identifier()));
        }
    }

    public static ItemStackRecipeBuilder stonecutting(Ingredient ingredient, RecipeCategory category, ItemStack result) {
        return new ItemStackRecipeBuilder(category, StonecutterRecipe::new, ingredient, result);
    }
}

