/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data.provider;

import com.google.common.base.Predicates;
import dev.apexstudios.apexcore.core.data.provider.BaseProvider;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderListenerContext;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderOutputContext;
import dev.apexstudios.apexcore.lib.data.provider.model.ModelProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

public final class ModelProviderImpl
implements BaseProvider,
ModelProvider {
    private final ModelProvider.ItemInfoCollector itemInfoCollector = new ModelProvider.ItemInfoCollector(this::filteredItems);
    private final ModelProvider.BlockStateGeneratorCollector blockStateGeneratorCollector = new ModelProvider.BlockStateGeneratorCollector(this::filteredBlocks);
    private final ModelProvider.SimpleModelCollector simpleModelCollector = new ModelProvider.SimpleModelCollector();
    private final BlockModelGenerators blockModels = new BlockModelGenerators((Consumer)this.blockStateGeneratorCollector, (ItemModelOutput)this.itemInfoCollector, (BiConsumer)this.simpleModelCollector);
    private final ItemModelGenerators itemModels = new ItemModelGenerators((ItemModelOutput)this.itemInfoCollector, (BiConsumer)this.simpleModelCollector);
    private final String modId;
    private Supplier<Stream<? extends Holder<Item>>> knownItemsSupplier = () -> ((DefaultedRegistry)BuiltInRegistries.ITEM).listElements();
    private Supplier<Stream<? extends Holder<Block>>> knownBlocksSupplier = () -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).listElements();
    private Predicate<Holder<Item>> itemFilter = Predicates.alwaysTrue();
    private Predicate<Holder<Block>> blockFilter = Predicates.alwaysTrue();

    @ApiStatus.Internal
    public ModelProviderImpl(ProviderListenerContext context) {
        this.modId = context.modId();
    }

    private Stream<? extends Holder<Item>> filteredItems() {
        return this.knownItemsSupplier.get().filter(holder -> ((ResourceKey)holder.unwrapKey().orElseThrow()).identifier().getNamespace().equals(this.modId)).filter(this.itemFilter);
    }

    private Stream<? extends Holder<Block>> filteredBlocks() {
        return this.knownBlocksSupplier.get().filter(holder -> ((ResourceKey)holder.unwrapKey().orElseThrow()).identifier().getNamespace().equals(this.modId)).filter(this.blockFilter);
    }

    @Override
    public CompletableFuture<?> generate(CachedOutput cache, ProviderOutputContext context) {
        this.blockStateGeneratorCollector.validate();
        this.itemInfoCollector.finalizeAndValidate();
        return CompletableFuture.allOf(this.blockStateGeneratorCollector.save(cache, context.pathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates")), this.simpleModelCollector.save(cache, context.pathProvider(PackOutput.Target.RESOURCE_PACK, "models")), this.itemInfoCollector.save(cache, context.pathProvider(PackOutput.Target.RESOURCE_PACK, "items")));
    }

    @Override
    public ModelProvider knownItems(Supplier<Stream<? extends Holder<Item>>> knownItemsSupplier) {
        this.knownItemsSupplier = knownItemsSupplier;
        return this;
    }

    @Override
    public ModelProvider knownBlocks(Supplier<Stream<? extends Holder<Block>>> knownBlocksSupplier) {
        this.knownBlocksSupplier = knownBlocksSupplier;
        return this;
    }

    @Override
    public ModelProvider itemFilter(Predicate<Holder<Item>> itemFilter) {
        this.itemFilter = this.itemFilter.and(itemFilter);
        return this;
    }

    @Override
    public ModelProvider blockFilter(Predicate<Holder<Block>> blockFilter) {
        this.blockFilter = this.blockFilter.and(blockFilter);
        return this;
    }

    @Override
    public BlockModelGenerators blockModels() {
        return this.blockModels;
    }

    @Override
    public ItemModelGenerators itemModels() {
        return this.itemModels;
    }
}

