/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.core.data.provider.BaseProvider;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.provider.ParticleProvider;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderOutputContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;

public final class ParticleProviderImpl
implements BaseProvider,
ParticleProvider {
    public static final ProviderType<ParticleProvider> PROVIDER_TYPE = ProviderType.register(ApexCore.identifier("particle"), ParticleProviderImpl::new);
    private final Map<Identifier, List<String>> descriptions = Maps.newHashMap();

    @Override
    public CompletableFuture<?> generate(CachedOutput cache, ProviderOutputContext context) {
        PackOutput.PathProvider pathProvider = context.pathProvider(PackOutput.Target.RESOURCE_PACK, "particles");
        return DataProvider.saveAll((CachedOutput)cache, (T desc) -> (JsonElement)Util.make((Object)new JsonObject(), root -> root.add("textures", (JsonElement)Util.make((Object)new JsonArray(), json -> desc.forEach(arg_0 -> ((JsonArray)json).add(arg_0))))), arg_0 -> ((PackOutput.PathProvider)pathProvider).json(arg_0), this.descriptions);
    }

    @Override
    public void spriteSet(ParticleType<?> particleType, Iterable<Identifier> textures) {
        Identifier registryName = Objects.requireNonNull(BuiltInRegistries.PARTICLE_TYPE.getKey(particleType));
        ArrayList desc = Lists.newArrayList();
        for (Identifier texture : textures) {
            desc.add(texture.toString());
        }
        if (this.descriptions.putIfAbsent(registryName, desc) != null) {
            throw new IllegalStateException("The particle type '" + String.valueOf(registryName) + "' already has a description associated with it");
        }
    }
}

