/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data.provider.tag;

import com.google.common.collect.Lists;
import dev.apexstudios.apexcore.core.data.provider.tag.IntrusiveTagBuilderImpl;
import dev.apexstudios.apexcore.core.data.provider.tag.SimpleTagBuilderImpl;
import dev.apexstudios.apexcore.lib.data.provider.tag.TagBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;

sealed class TagBuilderImpl<TRegistry, TSelf extends TagBuilder<TRegistry, TSelf>>
implements TagBuilder<TRegistry, TSelf>
permits SimpleTagBuilderImpl, IntrusiveTagBuilderImpl {
    private final List<TagEntry> elements = Lists.newArrayList();
    private final List<TagEntry> removals = Lists.newArrayList();
    private final String namespace;
    private boolean replace = false;

    protected TagBuilderImpl(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public TSelf replace() {
        this.replace = true;
        return (TSelf)this;
    }

    @Override
    public TSelf withElement(Identifier registryName) {
        this.elements.add(TagEntry.element((Identifier)registryName));
        return (TSelf)this;
    }

    @Override
    public TSelf withElement(String identifier) {
        return this.withElement(Identifier.fromNamespaceAndPath((String)this.namespace, (String)identifier));
    }

    @Override
    public TSelf withOptionalElement(Identifier registryName) {
        this.elements.add(TagEntry.optionalElement((Identifier)registryName));
        return (TSelf)this;
    }

    @Override
    public TSelf withOptionalElement(String identifier) {
        return this.withOptionalElement(Identifier.fromNamespaceAndPath((String)this.namespace, (String)identifier));
    }

    @Override
    public TSelf withTag(Identifier tagName) {
        this.elements.add(TagEntry.tag((Identifier)tagName));
        return (TSelf)this;
    }

    @Override
    public TSelf withOptionalTag(Identifier tagName) {
        this.elements.add(TagEntry.optionalTag((Identifier)tagName));
        return (TSelf)this;
    }

    @Override
    public TSelf removeElement(Identifier registryName) {
        this.removals.add(TagEntry.element((Identifier)registryName));
        return (TSelf)this;
    }

    @Override
    public TSelf removeElement(String identifier) {
        return this.removeElement(Identifier.fromNamespaceAndPath((String)this.namespace, (String)identifier));
    }

    @Override
    public TSelf removeOptionalElement(Identifier registryName) {
        this.removals.add(TagEntry.optionalElement((Identifier)registryName));
        return (TSelf)this;
    }

    @Override
    public TSelf removeOptionalElement(String identifier) {
        return this.removeOptionalElement(Identifier.fromNamespaceAndPath((String)this.namespace, (String)identifier));
    }

    @Override
    public TSelf removeTag(Identifier tagName) {
        this.removals.add(TagEntry.tag((Identifier)tagName));
        return (TSelf)this;
    }

    @Override
    public TSelf removeOptionalTag(Identifier tagName) {
        this.removals.add(TagEntry.optionalTag((Identifier)tagName));
        return (TSelf)this;
    }

    TagFile compile() {
        return new TagFile(TagBuilderImpl.copyAndSort(this.elements), this.replace, TagBuilderImpl.copyAndSort(this.removals));
    }

    private static List<TagEntry> copyAndSort(List<TagEntry> list) {
        ArrayList copy = Lists.newArrayList(list);
        copy.sort(Comparator.comparing(TagEntry::isRequired).thenComparing(TagEntry::getId).thenComparing(TagEntry::isTag));
        return Collections.unmodifiableList(copy);
    }
}

