/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.block;

import com.mojang.serialization.Codec;
import dev.apexstudios.registree.api.Registree;
import java.lang.runtime.SwitchBootstraps;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.Nullable;

public interface Dyeable {
    public static final DataComponentType<DyeColor> COMPONENT = DataComponents.BASE_COLOR;

    public boolean isBlankDyedColor(DyedColor var1);

    public DyedColor getCorrectedColor(DyedColor var1);

    public BlockState setDyedColor(BlockState var1, DyedColor var2);

    public DyedColor getDyedColor(BlockState var1);

    default public void setDyedColor(MutableDataComponentHolder components, DyedColor color) {
        if (this.isBlankDyedColor(color)) {
            components.remove(COMPONENT);
        } else if (color != this.getDyedColor((DataComponentGetter)components)) {
            components.set(COMPONENT, (Object)color.color);
        }
    }

    default public DyedColor getDyedColor(DataComponentGetter components) {
        return this.getCorrectedColor(DyedColor.from((DyeColor)components.get(COMPONENT)));
    }

    default public void setDyedColor(Level level, BlockPos pos, BlockState blockState, DyedColor color) {
        if (!level.isClientSide()) {
            level.setBlockAndUpdate(pos, this.setDyedColor(blockState, this.getCorrectedColor(color)));
        }
    }

    default public DyedColor getDyedColorForPlacement(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return this.getCorrectedColor(DyedColor.NONE);
        }
        InteractionHand hand = context.getHand();
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack stack = player.getItemInHand(otherHand);
        DyedColor color = this.getCorrectedColor(DyedColor.fromDye(stack));
        if (this.isBlankDyedColor(color)) {
            color = this.getDyedColor((DataComponentGetter)context.getItemInHand());
        }
        return color;
    }

    default public InteractionResult tryDyeBlock(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player) {
        DyedColor dye = this.getCorrectedColor(DyedColor.fromDye(stack));
        DyedColor currentColor = this.getDyedColor(blockState);
        if (player.isSecondaryUseActive()) {
            if (!this.isBlankDyedColor(currentColor)) {
                this.setDyedColor(level, pos, blockState, DyedColor.NONE);
                return InteractionResult.SUCCESS;
            }
        } else if (!this.isBlankDyedColor(dye) && dye != currentColor) {
            this.setDyedColor(level, pos, blockState, dye);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public void appendDyedColor(MutableDataComponentHolder components, BlockState blockState, @Nullable Player player, boolean includeData) {
        if (includeData || player != null && player.isCreative()) {
            this.setDyedColor(components, this.getDyedColor(blockState));
        }
    }

    public static Stream<Block> dyeableBlocks(Registree registree) {
        return registree.stream(Registries.BLOCK).filter(Dyeable.class::isInstance);
    }

    public static Stream<Item> dyeableItems(Registree registree) {
        return Dyeable.dyeableBlocks(registree).map(ItemLike::asItem);
    }

    public static void registerBlockColor(Registree registree, RegisterColorHandlersEvent.Block event) {
        event.register((blockState, level, pos, tintIndex) -> {
            Block patt0$temp;
            if (tintIndex == 0 && (patt0$temp = blockState.getBlock()) instanceof Dyeable) {
                Dyeable dyeable = (Dyeable)patt0$temp;
                DyeColor color = dyeable.getDyedColor((BlockState)blockState).color;
                return color == null ? -1 : color.getTextureDiffuseColor();
            }
            return -1;
        }, (Block[])Dyeable.dyeableBlocks(registree).toArray(Block[]::new));
    }

    public static enum DyedColor implements StringRepresentable
    {
        NONE(null),
        WHITE(DyeColor.WHITE),
        ORANGE(DyeColor.ORANGE),
        MAGENTA(DyeColor.MAGENTA),
        LIGHT_BLUE(DyeColor.LIGHT_BLUE),
        YELLOW(DyeColor.YELLOW),
        LIME(DyeColor.LIME),
        PINK(DyeColor.PINK),
        GRAY(DyeColor.GRAY),
        LIGHT_GRAY(DyeColor.LIGHT_GRAY),
        CYAN(DyeColor.CYAN),
        PURPLE(DyeColor.PURPLE),
        BLUE(DyeColor.BLUE),
        BROWN(DyeColor.BROWN),
        GREEN(DyeColor.GREEN),
        RED(DyeColor.RED),
        BLACK(DyeColor.BLACK);

        public static final Codec<DyedColor> CODEC;
        @Nullable
        private final DyeColor color;

        private DyedColor(DyeColor color) {
            this.color = color;
        }

        @Nullable
        public DyeColor getColor() {
            return this.color;
        }

        public String getSerializedName() {
            return this.color == null ? "none" : this.color.getSerializedName();
        }

        public static DyedColor fromDye(ItemStack stack) {
            return DyedColor.from(DyeColor.getColor((ItemStack)stack));
        }

        public static DyedColor from(@Nullable DyeColor color) {
            DyeColor dyeColor = color;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WHITE", "ORANGE", "MAGENTA", "LIGHT_BLUE", "YELLOW", "LIME", "PINK", "GRAY", "LIGHT_GRAY", "CYAN", "PURPLE", "BLUE", "BROWN", "GREEN", "RED", "BLACK"}, (DyeColor)dyeColor, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> WHITE;
                case 1 -> ORANGE;
                case 2 -> MAGENTA;
                case 3 -> LIGHT_BLUE;
                case 4 -> YELLOW;
                case 5 -> LIME;
                case 6 -> PINK;
                case 7 -> GRAY;
                case 8 -> LIGHT_GRAY;
                case 9 -> CYAN;
                case 10 -> PURPLE;
                case 11 -> BLUE;
                case 12 -> BROWN;
                case 13 -> GREEN;
                case 14 -> RED;
                case 15 -> BLACK;
                case -1 -> NONE;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(DyedColor::values);
        }
    }

    public static interface WithNone
    extends Dyeable {
        public static final EnumProperty<DyedColor> DYED_COLOR = EnumProperty.create((String)"color", DyedColor.class);

        @Override
        default public boolean isBlankDyedColor(DyedColor color) {
            return color == DyedColor.NONE;
        }

        @Override
        default public DyedColor getCorrectedColor(DyedColor color) {
            return color;
        }

        @Override
        default public BlockState setDyedColor(BlockState blockState, DyedColor color) {
            return (BlockState)blockState.setValue(DYED_COLOR, (Comparable)((Object)color));
        }

        @Override
        default public DyedColor getDyedColor(BlockState blockState) {
            return (DyedColor)((Object)blockState.getValue(DYED_COLOR));
        }
    }

    public static interface Colored
    extends Dyeable {
        public static final EnumProperty<DyedColor> DYED_COLOR = EnumProperty.create((String)"color", DyedColor.class, color -> color.color != null);

        @Override
        default public boolean isBlankDyedColor(DyedColor color) {
            return color == DyedColor.NONE || color == DyedColor.WHITE;
        }

        @Override
        default public DyedColor getCorrectedColor(DyedColor color) {
            return color == DyedColor.NONE ? DyedColor.WHITE : color;
        }

        @Override
        default public BlockState setDyedColor(BlockState blockState, DyedColor color) {
            return (BlockState)blockState.setValue(DYED_COLOR, (Comparable)((Object)this.getCorrectedColor(color)));
        }

        @Override
        default public DyedColor getDyedColor(BlockState blockState) {
            return (DyedColor)((Object)blockState.getValue(DYED_COLOR));
        }
    }
}

