/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.block;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.core.seat.SeatEntity;
import dev.apexstudios.apexcore.lib.util.ApexTags;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.Identifier;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.NotNull;

public interface Seat {
    public static final EntityCapability<Runnable, @NotNull CapabilityContext> SEATED_CAPABILITY = EntityCapability.create((Identifier)ApexCore.identifier("seated"), Runnable.class, CapabilityContext.class);
    public static final EntityCapability<Runnable, @NotNull CapabilityContext> UNSEATED_CAPABILITY = EntityCapability.create((Identifier)ApexCore.identifier("unseated"), Runnable.class, CapabilityContext.class);
    public static final EntityCapability<BooleanSupplier, @NotNull CapabilityContext> MAY_SIT_CAPABILITY = EntityCapability.create((Identifier)ApexCore.identifier("may_sit"), BooleanSupplier.class, CapabilityContext.class);
    public static final BooleanProperty DEFAULT_PROPERTY = BlockStateProperties.OCCUPIED;

    default public Vec3 getSeatPosition(BlockGetter level, BlockPos pos, BlockState blockState) {
        return Vec3.atCenterOf((Vec3i)pos);
    }

    default public boolean isSeatOccupied(BlockState blockState) {
        return (Boolean)blockState.getValueOrElse((Property)DEFAULT_PROPERTY, (Comparable)Boolean.valueOf(false));
    }

    default public void setSeatOccupied(Level level, BlockPos pos, BlockState blockState, boolean occupied) {
        level.setBlockAndUpdate(pos, (BlockState)blockState.trySetValue((Property)DEFAULT_PROPERTY, (Comparable)Boolean.valueOf(occupied)));
    }

    public static Vec3 getPosition(BlockGetter level, BlockPos pos, BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof Seat) {
            Seat seat = (Seat)block;
            return seat.getSeatPosition(level, pos, blockState);
        }
        return Vec3.atCenterOf((Vec3i)pos);
    }

    public static boolean isOccupied(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof Seat) {
            Seat seat = (Seat)block;
            return seat.isSeatOccupied(blockState);
        }
        return (Boolean)blockState.getValueOrElse((Property)DEFAULT_PROPERTY, (Comparable)Boolean.valueOf(false));
    }

    public static void setOccupied(Level level, BlockPos pos, BlockState blockState, boolean occupied) {
        Block block = blockState.getBlock();
        if (block instanceof Seat) {
            Seat seat = (Seat)block;
            seat.setSeatOccupied(level, pos, blockState, occupied);
        } else {
            level.setBlockAndUpdate(pos, (BlockState)blockState.trySetValue((Property)DEFAULT_PROPERTY, (Comparable)Boolean.valueOf(occupied)));
        }
    }

    public static void setOccupied(Level level, BlockPos pos, boolean occupied) {
        Seat.setOccupied(level, pos, level.getBlockState(pos), occupied);
    }

    public static boolean maySit(EntityType<?> entityType) {
        return !entityType.is(ApexTags.EntityTypes.SEAT_BLACKLIST);
    }

    public static boolean maySit(Entity entity) {
        if (!Seat.maySit(entity.getType())) {
            return false;
        }
        if (entity.hasControllingPassenger()) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        BooleanSupplier maySit = (BooleanSupplier)entity.getCapability(MAY_SIT_CAPABILITY, (Object)new CapabilityContext(entity.getOnPos(), entity.getBlockStateOn()));
        return maySit == null || maySit.getAsBoolean();
    }

    public static void notifyCapabilityListeners(Entity entity, BlockPos pos, BlockState blockState, boolean seated) {
        Runnable capability = (Runnable)entity.getCapability(seated ? SEATED_CAPABILITY : UNSEATED_CAPABILITY, (Object)new CapabilityContext(pos, blockState));
        if (capability != null) {
            capability.run();
        }
    }

    public static <TEntity extends Entity> void registerCapabilities(RegisterCapabilitiesEvent event, EntityType<TEntity> entityType, TriConsumer<TEntity, BlockPos, BlockState> seated, TriConsumer<TEntity, BlockPos, BlockState> unseated) {
        event.registerEntity(SEATED_CAPABILITY, entityType, (entity, context) -> () -> seated.accept(entity, (Object)context.pos(), (Object)context.blockState()));
        event.registerEntity(UNSEATED_CAPABILITY, entityType, (entity, context) -> () -> unseated.accept(entity, (Object)context.pos(), (Object)context.blockState()));
    }

    @SafeVarargs
    public static <TEntity extends Entity> void registerCapabilities(RegisterCapabilitiesEvent event, TriConsumer<TEntity, BlockPos, BlockState> seated, TriConsumer<TEntity, BlockPos, BlockState> unseated, EntityType<? extends TEntity> ... entityTypes) {
        for (EntityType<? extends TEntity> entityType : entityTypes) {
            Seat.registerCapabilities(event, entityType, (arg_0, arg_1, arg_2) -> seated.accept(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2) -> unseated.accept(arg_0, arg_1, arg_2));
        }
    }

    public static InteractionResult interactWith(Level level, BlockPos pos, LivingEntity sitter) {
        InteractionResult result = Seat.trySit(level, pos, sitter);
        if (!result.consumesAction()) {
            result = Seat.tryUnsit(level, pos);
        }
        return result;
    }

    public static InteractionResult trySit(Level level, BlockPos pos, LivingEntity sitter) {
        return SeatEntity.sit(level, pos, sitter) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static InteractionResult tryUnsit(Level level, BlockPos pos) {
        return SeatEntity.unsit(level, pos) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public record CapabilityContext(BlockPos pos, BlockState blockState) {
    }
}

