/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider;

import dev.apexstudios.apexcore.core.data.provider.LanguageProviderImpl;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gamerules.GameRule;
import net.neoforged.neoforge.common.Tags;

public interface LanguageProvider {
    public static final ProviderType<LanguageProvider> PROVIDER_TYPE = LanguageProviderImpl.PROVIDER_TYPE;

    public LanguageProvider add(String var1, String var2);

    default public LanguageProvider add(String key, String value, String descriptionValue) {
        return this.add(key, value).add(key + ".description", descriptionValue);
    }

    default public LanguageProvider addBlock(Supplier<? extends Block> key, String name) {
        return this.add(key.get(), name);
    }

    default public LanguageProvider add(Block key, String name) {
        return this.add(key.getDescriptionId(), name);
    }

    default public LanguageProvider addItem(Supplier<? extends Item> key, String name) {
        return this.add(key.get(), name);
    }

    default public LanguageProvider add(Item key, String name) {
        return this.add(key.getDescriptionId(), name);
    }

    default public LanguageProvider addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        return this.add(key.get(), name);
    }

    default public LanguageProvider add(EntityType<?> key, String name) {
        return this.add(key.getDescriptionId(), name);
    }

    default public LanguageProvider addTag(Supplier<? extends TagKey<?>> key, String name) {
        return this.add(key.get(), name);
    }

    default public LanguageProvider add(TagKey<?> tagKey, String name) {
        return this.add(Tags.getTagTranslationKey(tagKey), name);
    }

    default public LanguageProvider add(ResourceKey<?> registyrKey, String translationPrefix, String value) {
        return this.add(registyrKey.identifier().toLanguageKey(translationPrefix), value);
    }

    default public LanguageProvider addDimension(ResourceKey<Level> dimension, String value) {
        return this.add(dimension, "dimension", value);
    }

    default public LanguageProvider addCreativeModeTab(ResourceKey<CreativeModeTab> creativeModeTab, String value) {
        return this.add(creativeModeTab, "itemGroup", value);
    }

    default public LanguageProvider add(GameRule<?> gameRule, String value, String descriptionValue) {
        return this.add(gameRule.getDescriptionId(), value, descriptionValue);
    }

    default public LanguageProvider addGameRule(Supplier<? extends GameRule<?>> gameRule, String value, String descriptionValue) {
        return this.add(gameRule.get(), value, descriptionValue);
    }
}

