/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider;

import dev.apexstudios.apexcore.core.data.provider.ParticleProviderImpl;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.Identifier;

public interface ParticleProvider {
    public static final ProviderType<ParticleProvider> PROVIDER_TYPE = ParticleProviderImpl.PROVIDER_TYPE;

    default public void sprite(ParticleType<?> particleType, Identifier texture) {
        this.spriteSet(particleType, texture, new Identifier[0]);
    }

    default public void spriteSet(ParticleType<?> particleType, final Identifier baseTexturePath, final int numTextures, final boolean reverse) {
        this.spriteSet(particleType, () -> new Iterator<Identifier>(this){
            private int counter = 0;

            @Override
            public boolean hasNext() {
                return this.counter < numTextures;
            }

            @Override
            public Identifier next() {
                Identifier texture = baseTexturePath.withSuffix("_" + (reverse ? numTextures - this.counter - 1 : this.counter));
                ++this.counter;
                return texture;
            }
        });
    }

    default public void spriteSet(ParticleType<?> particleType, Identifier texture, Identifier ... textures) {
        this.spriteSet(particleType, Stream.concat(Stream.of(texture), Stream.of(textures))::iterator);
    }

    public void spriteSet(ParticleType<?> var1, Iterable<Identifier> var2);
}

