/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.loot;

import dev.apexstudios.apexcore.lib.data.provider.loot.LootTableSubProvider;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public interface BlockLootSubProvider
extends LootTableSubProvider {
    public static final Set<Item> VANILLA_EXPLOSION_RESISTANT = VanillaBlockLoot.EXPLOSION_RESISTANT;
    public static final float[] JUNGLE_LEAVES_SAPLING_CHANGES = VanillaBlockLoot.JUNGLE_LEAVES_SAPLING_CHANGES;
    public static final float[] NORMAL_LEAVES_SAPLING_CHANCES = net.minecraft.data.loot.BlockLootSubProvider.NORMAL_LEAVES_SAPLING_CHANCES;
    public static final float[] NORMAL_LEAVES_STICK_CHANCES = net.minecraft.data.loot.BlockLootSubProvider.NORMAL_LEAVES_STICK_CHANCES;

    default public void accept(Holder<Block> block, Supplier<LootTable.Builder> lootTable) {
        this.accept((Block)block.value(), lootTable);
    }

    default public void accept(Holder<Block> block, LootTable.Builder lootTable) {
        this.accept(block, () -> lootTable);
    }

    default public void accept(Block block, Supplier<LootTable.Builder> lootTable) {
        this.accept((ResourceKey<LootTable>)((ResourceKey)block.getLootTable().orElseThrow(() -> new IllegalStateException("Block " + String.valueOf(block.builtInRegistryHolder().key().identifier()) + " does not have loot table"))), lootTable);
    }

    default public void accept(Block block, LootTable.Builder lootTable) {
        this.accept(block, () -> lootTable);
    }

    public LootItemCondition.Builder hasSilkTouch();

    public LootItemCondition.Builder doesNotHaveSilkTouch();

    public LootItemCondition.Builder hasShears();

    public LootItemCondition.Builder hasShearsOrSilkTouch();

    public LootItemCondition.Builder doesNotHaveShearsOrSilkTouch();

    public <T extends FunctionUserBuilder<T>> T applyExplosionDecay(ItemLike var1, FunctionUserBuilder<T> var2);

    public <T extends ConditionUserBuilder<T>> T applyExplosionCondition(ItemLike var1, ConditionUserBuilder<T> var2);

    public LootTable.Builder createSingleItemTable(ItemLike var1);

    public LootTable.Builder createSilkTouchDispatchTable(Block var1, LootPoolEntryContainer.Builder<?> var2);

    public LootTable.Builder createShearsDispatchTable(Block var1, LootPoolEntryContainer.Builder<?> var2);

    public LootTable.Builder createSilkTouchOrShearsDispatchTable(Block var1, LootPoolEntryContainer.Builder<?> var2);

    public LootTable.Builder createSingleItemTableWithSilkTouch(Block var1, ItemLike var2);

    public LootTable.Builder createSingleItemTable(ItemLike var1, NumberProvider var2);

    public LootTable.Builder createSingleItemTableWithSilkTouch(Block var1, ItemLike var2, NumberProvider var3);

    public LootTable.Builder createSilkTouchOnlyTable(ItemLike var1);

    public LootTable.Builder createPotFlowerItemTable(ItemLike var1);

    public LootTable.Builder createSlabItemTable(Block var1);

    public <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(Block var1, Property<T> var2, T var3);

    public LootTable.Builder createNameableBlockEntityTable(Block var1);

    public LootTable.Builder createShulkerBoxDrop(Block var1);

    public LootTable.Builder createCopperOreDrops(Block var1);

    public LootTable.Builder createLapisOreDrops(Block var1);

    public LootTable.Builder createRedstoneOreDrops(Block var1);

    public LootTable.Builder createBannerDrop(Block var1);

    public LootTable.Builder createBeeNestDrop(Block var1);

    public LootTable.Builder createBeeHiveDrop(Block var1);

    public LootTable.Builder createCaveVinesDrop(Block var1);

    public LootTable.Builder createOreDrop(Block var1, Item var2);

    public LootTable.Builder createMushroomBlockDrop(Block var1, ItemLike var2);

    public LootTable.Builder createGrassDrops(Block var1);

    public LootTable.Builder createStemDrops(Block var1, Item var2);

    public LootTable.Builder createAttachedStemDrops(Block var1, Item var2);

    public LootTable.Builder createShearsOnlyDrop(ItemLike var1);

    public LootTable.Builder createShearsOrSilkTouchOnlyDrop(ItemLike var1);

    public LootTable.Builder createMultifaceBlockDrops(Block var1, LootItemCondition.Builder var2);

    public LootTable.Builder createMultifaceBlockDrops(Block var1);

    public LootTable.Builder createMossyCarpetBlockDrops(Block var1);

    public LootTable.Builder createLeavesDrops(Block var1, Block var2, float ... var3);

    public LootTable.Builder createOakLeavesDrops(Block var1, Block var2, float ... var3);

    public LootTable.Builder createMangroveLeavesDrops(Block var1);

    public LootTable.Builder createCropDrops(Block var1, Item var2, Item var3, LootItemCondition.Builder var4);

    public LootTable.Builder createDoublePlantShearsDrop(Block var1);

    public LootTable.Builder createDoublePlantWithSeedDrops(Block var1, Block var2);

    public LootTable.Builder createCandleDrops(Block var1);

    public LootTable.Builder createSegmentedBlockDrops(Block var1);

    public void addNetherVinesDropTable(Block var1, Block var2);

    public LootTable.Builder createDoorTable(Block var1);

    public void dropPottedContents(Block var1);

    public void otherWhenSilkTouch(Block var1, Block var2);

    public void dropOther(Block var1, ItemLike var2);

    public void dropWhenSilkTouch(Block var1);

    public void dropSelf(Block var1);

    public static LootTable.Builder createSelfDropDispatchTable(Block block, LootItemCondition.Builder conditionBuilder, LootPoolEntryContainer.Builder<?> alternativeBuilder) {
        return net.minecraft.data.loot.BlockLootSubProvider.createSelfDropDispatchTable((Block)block, (LootItemCondition.Builder)conditionBuilder, alternativeBuilder);
    }

    public static LootTable.Builder createCandleCakeDrops(Block candleCakeBlock) {
        return net.minecraft.data.loot.BlockLootSubProvider.createCandleCakeDrops((Block)candleCakeBlock);
    }

    public static LootTable.Builder noDrop() {
        return net.minecraft.data.loot.BlockLootSubProvider.noDrop();
    }
}

