/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.loot;

import dev.apexstudios.apexcore.lib.data.provider.loot.LootTableSubProvider;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public interface EntityLootSubProvider
extends LootTableSubProvider {
    default public void accept(Holder<EntityType<?>> entityType, Supplier<LootTable.Builder> lootTable) {
        this.accept((EntityType)entityType.value(), lootTable);
    }

    default public void accept(Holder<EntityType<?>> entityType, LootTable.Builder lootTable) {
        this.accept(entityType, () -> lootTable);
    }

    default public void accept(EntityType<?> entityType, Supplier<LootTable.Builder> lootTable) {
        this.accept((ResourceKey<LootTable>)((ResourceKey)entityType.getDefaultLootTable().orElseThrow(() -> new IllegalStateException("Entity " + String.valueOf(entityType) + " has no loot table"))), lootTable);
    }

    default public void accept(EntityType<?> entityType, LootTable.Builder lootTable) {
        this.accept(entityType, () -> lootTable);
    }

    public AnyOfCondition.Builder shouldSmeltLoot();

    public LootItemCondition.Builder killedByFrog(HolderGetter<EntityType<?>> var1);

    public LootItemCondition.Builder killedByFrogVariant(HolderGetter<EntityType<?>> var1, HolderGetter<FrogVariant> var2, ResourceKey<FrogVariant> var3);

    public static LootPool.Builder createSheepDispatchPool(Map<DyeColor, ResourceKey<LootTable>> lootTables) {
        return net.minecraft.data.loot.EntityLootSubProvider.createSheepDispatchPool(lootTables);
    }
}

