/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.multiblock;

import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleMultiBlock
extends Block
implements MultiBlock {
    public SimpleMultiBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getMultiBlockProperty(), (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getMultiBlockProperty()});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placementBlockState = super.getStateForPlacement(context);
        if (placementBlockState == null || !MultiBlock.canPlace(context, placementBlockState)) {
            return null;
        }
        return placementBlockState;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, blockState, placer, stack);
        MultiBlock.setBlockStates(level, pos, blockState);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState blockState) {
        super.destroy(level, pos, blockState);
        MultiBlock.destroyBlocks(level, pos, blockState);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState blockState) {
        super.spawnDestroyParticles(level, player, pos, blockState);
        MultiBlock.spawnDestroyParticles((LevelAccessor)level, pos, blockState, (Entity)player);
    }
}

