/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.handler;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.PacketReceiver;
import lol.bai.badpackets.api.PacketSender;
import lol.bai.badpackets.impl.Constants;
import lol.bai.badpackets.impl.payload.UntypedPayload;
import lol.bai.badpackets.impl.platform.PlatformProxy;
import lol.bai.badpackets.impl.registry.ChannelRegistry;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.util.thread.BlockableEventLoop;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPacketHandler<C, B extends FriendlyByteBuf>
implements PacketSender {
    protected final ChannelRegistry<B, C> registry;
    protected final Logger logger;
    private final Function<CustomPacketPayload, Packet<?>> packetFactory;
    private final Set<Identifier> sendableChannels = Collections.synchronizedSet(new HashSet());
    private final BlockableEventLoop<?> eventLoop;
    private final Connection connection;
    private boolean initialized = false;

    protected AbstractPacketHandler(String desc, ChannelRegistry<B, C> registry, Function<CustomPacketPayload, Packet<?>> packetFactory, BlockableEventLoop<?> eventLoop, Connection connection) {
        this.logger = LogManager.getLogger((String)desc);
        this.registry = registry;
        this.packetFactory = packetFactory;
        this.eventLoop = eventLoop;
        this.connection = connection;
        registry.addHandler(this);
    }

    private void receiveChannelSyncPacket(FriendlyByteBuf buf) {
        switch (buf.readByte()) {
            case 0: {
                this.sendableChannels.add(buf.readIdentifier());
                break;
            }
            case 1: {
                int groupSize = buf.readVarInt();
                for (int i = 0; i < groupSize; ++i) {
                    String namespace = buf.readUtf();
                    int pathSize = buf.readVarInt();
                    for (int j = 0; j < pathSize; ++j) {
                        String path = buf.readUtf();
                        this.sendableChannels.add(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
                    }
                }
                this.eventLoop.execute(this::onInitialChannelSyncPacketReceived);
            }
        }
    }

    public boolean receive(CustomPacketPayload payload) {
        Identifier id = payload.type().id();
        if (id.equals((Object)Constants.CHANNEL_SYNC)) {
            UntypedPayload untyped = (UntypedPayload)payload;
            this.receiveChannelSyncPacket(untyped.buffer());
            return true;
        }
        if (this.registry.has(id)) {
            try {
                PacketReceiver<C, CustomPacketPayload> receiver = this.registry.get(id);
                if (payload instanceof UntypedPayload || this.eventLoop.isSameThread()) {
                    this.receiveUnsafe(receiver, payload);
                } else {
                    this.eventLoop.execute(() -> {
                        if (this.connection.isConnected()) {
                            this.receiveUnsafe(receiver, payload);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.logger.error("Error when receiving packet {}", (Object)id, (Object)t);
                throw t;
            }
            return true;
        }
        return false;
    }

    protected abstract void onInitialChannelSyncPacketReceived();

    protected abstract void receiveUnsafe(PacketReceiver<C, CustomPacketPayload> var1, CustomPacketPayload var2);

    public void sendInitialChannelSyncPacket() {
        if (!this.initialized) {
            this.initialized = true;
            this.sendVanillaChannelRegisterPacket(Set.of(Constants.CHANNEL_SYNC));
            Set<Identifier> channels = this.registry.getChannels();
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeByte((byte)1);
            Map<String, List<Identifier>> group = channels.stream().collect(Collectors.groupingBy(Identifier::getNamespace));
            buf.writeVarInt(group.size());
            for (Map.Entry<String, List<Identifier>> entry : group.entrySet()) {
                buf.writeUtf(entry.getKey());
                buf.writeVarInt(entry.getValue().size());
                for (Identifier value : entry.getValue()) {
                    buf.writeUtf(value.getPath());
                }
            }
            this.send(Constants.CHANNEL_SYNC, buf);
            this.sendVanillaChannelRegisterPacket(channels);
        }
    }

    public void onRegister(Identifier id) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeByte((byte)0);
        buf.writeIdentifier(id);
        this.send(Constants.CHANNEL_SYNC, buf);
        this.sendVanillaChannelRegisterPacket(Set.of(id));
    }

    public void remove() {
        this.registry.removeHandler(this);
    }

    private void sendVanillaChannelRegisterPacket(Set<Identifier> channels) {
        if (PlatformProxy.INSTANCE.canSendVanillaRegisterPackets() && !channels.isEmpty()) {
            this.connection.send(this.createVanillaRegisterPacket(channels, buf -> {
                boolean first = true;
                for (Identifier channel : channels) {
                    if (first) {
                        first = false;
                    } else {
                        buf.writeByte(0);
                    }
                    buf.writeBytes(channel.toString().getBytes(StandardCharsets.US_ASCII));
                }
            }));
        }
    }

    protected abstract Packet<?> createVanillaRegisterPacket(Set<Identifier> var1, Consumer<B> var2);

    @Override
    public void send(CustomPacketPayload payload, @Nullable ChannelFutureListener callback) {
        this.connection.send(this.packetFactory.apply(payload), callback);
    }

    @Override
    public boolean canSend(Identifier id) {
        return this.sendableChannels.contains(id);
    }
}

