/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows;

import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ScarecrowTracker {
    private static final Map<ResourceKey<Level>, Collection<Integer>> TRACKED_SCARECROWS = new ConcurrentHashMap<ResourceKey<Level>, Collection<Integer>>();

    private ScarecrowTracker() {
    }

    public static void track(Scarecrow entity) {
        ScarecrowTracker.getTrackedScarecrows(entity.level()).add(entity.getId());
    }

    public static void stopTracking(Scarecrow entity) {
        ScarecrowTracker.getTrackedScarecrows(entity.level()).remove(entity.getId());
    }

    public static List<Scarecrow> getScarecrowsInRange(Level level, BlockPos pos) {
        Collection<Integer> scarecrows = ScarecrowTracker.getTrackedScarecrows(level);
        ArrayList<Scarecrow> returnValue = new ArrayList<Scarecrow>();
        Iterator<Integer> it = scarecrows.iterator();
        while (it.hasNext()) {
            Entity entity = level.getEntity(it.next().intValue());
            if (entity instanceof Scarecrow) {
                Scarecrow scarecrow = (Scarecrow)entity;
                if (!ScarecrowTracker.canScarecrowReach(scarecrow, pos)) continue;
                returnValue.add(scarecrow);
                continue;
            }
            it.remove();
        }
        return returnValue;
    }

    private static Collection<Integer> getTrackedScarecrows(Level level) {
        Collection<Integer> scarecrows = TRACKED_SCARECROWS.get(level.dimension());
        if (scarecrows == null) {
            scarecrows = ConcurrentHashMap.newKeySet();
            TRACKED_SCARECROWS.put((ResourceKey<Level>)level.dimension(), scarecrows);
        }
        return scarecrows;
    }

    private static boolean canScarecrowReach(Scarecrow entity, BlockPos pos) {
        AABB scarecrowRange = entity.getArea();
        return scarecrowRange.minX <= (double)pos.getX() && scarecrowRange.minY <= (double)pos.getY() && scarecrowRange.minZ <= (double)pos.getZ() && scarecrowRange.maxX >= (double)pos.getX() && scarecrowRange.maxY >= (double)pos.getY() && scarecrowRange.maxZ >= (double)pos.getZ();
    }
}

