/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.ai;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import bl4ckscor3.mod.scarecrows.util.EntityUtil;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class RunAwayGoal
extends Goal {
    private static final float SPEED = 1.5f;
    private final Predicate<Entity> canBeSeenSelector = e -> e.isAlive() && entity.getSensing().hasLineOfSight(e);
    private Mob entity;
    private Path path;
    private final PathNavigation navigation;
    private long ticksSinceSound = 0L;

    public RunAwayGoal(Mob entity) {
        this.entity = entity;
        this.navigation = entity.getNavigation();
    }

    public boolean canUse() {
        List<Scarecrow> list = ScarecrowTracker.getScarecrowsInRange(this.entity.level(), this.entity.blockPosition());
        for (Scarecrow scarecrow : list) {
            if (!this.canBeSeenSelector.apply((Object)scarecrow) || !EntityUtil.isAttackableMonster((Entity)this.entity) && (!scarecrow.getScarecrowType().shouldScareAnimals() || !EntityUtil.isAttackableAnimal((Entity)this.entity)) || !this.shouldScare(scarecrow)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldScare(Scarecrow scarecrow) {
        List entities = scarecrow.level().getEntitiesOfClass(this.entity.getClass(), scarecrow.getArea());
        for (Mob e : entities) {
            if (e != this.entity) continue;
            if (e.distanceTo((Entity)scarecrow) <= (float)scarecrow.getScarecrowType().getRange()) {
                Vec3 scarecrowPos = new Vec3(scarecrow.getX(), scarecrow.getY(), scarecrow.getZ());
                Vec3 currentPos = new Vec3(e.getX(), e.getY(), e.getZ());
                Vec3 newPosition = EntityUtil.generateRandomPos(e, 16, 7, currentPos.subtract(scarecrowPos), true);
                if (newPosition == null || scarecrow.distanceToSqr(newPosition.x, newPosition.y, newPosition.z) < scarecrow.distanceToSqr((Entity)e)) {
                    return false;
                }
                this.path = this.navigation.createPath(BlockPos.containing((Position)newPosition), 0);
                return this.path != null;
            }
            return false;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.navigation.isDone();
    }

    public void start() {
        this.navigation.moveTo(this.path, 1.5);
    }

    public void tick() {
        if (this.ticksSinceSound == 0L) {
            this.entity.playAmbientSound();
            this.createRunningParticles((Entity)this.entity);
            this.ticksSinceSound = 10L;
        } else {
            --this.ticksSinceSound;
        }
        this.entity.setTarget(null);
        this.entity.getNavigation().setSpeedModifier(1.5);
    }

    private void createRunningParticles(Entity entity) {
        int x = Mth.floor((double)entity.getX());
        int y = Mth.floor((double)(entity.getY() - (double)0.2f));
        int z = Mth.floor((double)entity.getZ());
        BlockPos pos = new BlockPos(x, y, z);
        Level level = entity.level();
        BlockState state = level.getBlockState(pos);
        if (!state.addRunningEffects(level, pos, entity) && state.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 motion = entity.getDeltaMovement();
            EntityDimensions size = entity.getDimensions(entity.getPose());
            RandomSource rand = level.random;
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state, pos), entity.getX() + (rand.nextDouble() - 0.5) * (double)size.width(), entity.getY() + 0.1, entity.getZ() + (rand.nextDouble() - 0.5) * (double)size.width(), motion.x * -4.0, 1.5, motion.z * -4.0);
        }
    }
}

