/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.entity;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.type.ScarecrowType;
import bl4ckscor3.mod.scarecrows.type.SpoopyScarecrow;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class Scarecrow
extends Entity {
    private static final EntityDataAccessor<ScarecrowType> TYPE = SynchedEntityData.defineId(Scarecrow.class, (EntityDataSerializer)((EntityDataSerializer)Scarecrows.SCARECROW_ENTITY_DATA_SERIALIZER.get()));
    private static final EntityDataAccessor<Boolean> LIT = SynchedEntityData.defineId(Scarecrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.defineId(Scarecrow.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<AABB> AREA = SynchedEntityData.defineId(Scarecrow.class, (EntityDataSerializer)((EntityDataSerializer)Scarecrows.AABB_ENTITY_DATA_SERIALIZER.get()));

    public Scarecrow(EntityType<Scarecrow> type, Level world) {
        super(type, world);
    }

    public Scarecrow(Level world) {
        super((EntityType)Scarecrows.SCARECROW_ENTITY_TYPE.get(), world);
    }

    public Scarecrow(ScarecrowType type, Level world, BlockPos pos, boolean isLit, Direction facing) {
        this(world);
        this.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        this.entityData.set(TYPE, (Object)type);
        this.entityData.set(LIT, (Object)isLit);
        this.entityData.set(ROTATION, (Object)Float.valueOf(facing.toYRot() + 180.0f));
        this.entityData.set(AREA, (Object)new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ()).inflate((double)type.getRange(), (double)(type.getHeight() * 3), (double)type.getRange()));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TYPE, (Object)SpoopyScarecrow.TYPE);
        builder.define(LIT, (Object)false);
        builder.define(ROTATION, (Object)Float.valueOf(0.0f));
        builder.define(AREA, (Object)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        ScarecrowTracker.track(this);
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        ScarecrowTracker.stopTracking(this);
    }

    public void tick() {
        if (this.level().getBlockState(this.blockPosition().below()).isAir()) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (!this.level().isClientSide()) {
            if (this.isLit()) {
                this.level().destroyBlock(this.blockPosition().above(this.getScarecrowType().getHeight() - 1), false);
            }
            this.getScarecrowType().dropMaterials(this.level(), this.blockPosition(), this.isLit());
        }
    }

    protected void readAdditionalSaveData(ValueInput tag) {
        String name = tag.getStringOr("type", SpoopyScarecrow.TYPE.getName());
        for (ScarecrowType st : Scarecrows.TYPES) {
            if (!st.getName().equals(name)) continue;
            this.entityData.set(TYPE, (Object)st);
            break;
        }
        this.entityData.set(LIT, (Object)tag.getBooleanOr("isLit", false));
        this.entityData.set(ROTATION, (Object)Float.valueOf(tag.getFloatOr("rotation", 0.0f)));
        this.entityData.set(AREA, (Object)new AABB(tag.getDoubleOr("areaMinX", 0.0), tag.getDoubleOr("areaMinY", 0.0), tag.getDoubleOr("areaMinZ", 0.0), tag.getDoubleOr("areaMaxX", 0.0), tag.getDoubleOr("areaMaxY", 0.0), tag.getDoubleOr("areaMaxZ", 0.0)));
    }

    protected void addAdditionalSaveData(ValueOutput tag) {
        AABB area = this.getArea();
        tag.putString("type", this.getScarecrowType().getName());
        tag.putBoolean("isLit", this.isLit());
        tag.putFloat("rotation", this.getRotation().floatValue());
        tag.putDouble("areaMinX", area.minX);
        tag.putDouble("areaMinY", area.minY);
        tag.putDouble("areaMinZ", area.minZ);
        tag.putDouble("areaMaxX", area.maxX);
        tag.putDouble("areaMaxY", area.maxY);
        tag.putDouble("areaMaxZ", area.maxZ);
    }

    public ScarecrowType getScarecrowType() {
        return (ScarecrowType)this.entityData.get(TYPE);
    }

    public boolean isLit() {
        return (Boolean)this.entityData.get(LIT);
    }

    public Float getRotation() {
        return (Float)this.entityData.get(ROTATION);
    }

    public AABB getArea() {
        return (AABB)this.entityData.get(AREA);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        return false;
    }
}

