/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.handler;

import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.block.ArmBlock;
import bl4ckscor3.mod.scarecrows.type.ScarecrowType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="scarecrows")
public class PlaceHandler {
    private PlaceHandler() {
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        if (held.getItem() == Items.STICK) {
            BlockPos pos = event.getPos();
            Direction face = event.getFace();
            BlockPos placeAt = pos.relative(face);
            Level world = event.getLevel();
            if (face != Direction.UP && face != Direction.DOWN && ArmBlock.canBeConnectedTo((BlockGetter)world, placeAt, face) && world.isEmptyBlock(placeAt)) {
                world.setBlockAndUpdate(placeAt, (BlockState)((ArmBlock)((Object)Scarecrows.ARM.get())).defaultBlockState().setValue(ArmBlock.FACING, (Comparable)face));
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundType.WOOD.getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                event.getEntity().swing(event.getHand());
                if (!event.getEntity().isCreative()) {
                    held.shrink(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        PlaceHandler.tryBuildScarecrow(event.getLevel(), event.getPos(), event.getPlacedBlock());
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        PlaceHandler.tryBuildScarecrow((LevelAccessor)event.getLevel(), event.getPos(), event.getLevel().getBlockState(event.getPos()));
    }

    public static void tryBuildScarecrow(LevelAccessor level, BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        if (block == Blocks.CARVED_PUMPKIN || block == Blocks.JACK_O_LANTERN) {
            for (ScarecrowType type : Scarecrows.TYPES) {
                Direction pumpkinFacing = (Direction)state.getValue((Property)CarvedPumpkinBlock.FACING);
                BlockPos groundPos = pos.below(type.getHeight());
                BlockState groundState = level.getBlockState(groundPos);
                if (groundState.isAir() || !type.checkStructure(level, pos, pumpkinFacing)) continue;
                type.destroy(level, pos);
                type.spawn(type, level, pos.below(type.getHeight() - 1), block == Blocks.JACK_O_LANTERN, pumpkinFacing);
                return;
            }
        }
    }
}

