/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.handler;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.ai.RunAwayGoal;
import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import bl4ckscor3.mod.scarecrows.util.EntityUtil;
import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;

@EventBusSubscriber(modid="scarecrows")
public class SpawnHandler {
    private SpawnHandler() {
    }

    @SubscribeEvent
    public static void onCheckSpawn(FinalizeSpawnEvent event) {
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (!(serverLevelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)serverLevelAccessor;
        Mob entity = event.getEntity();
        boolean animal = EntityUtil.isAttackableAnimal((Entity)entity);
        if (EntityUtil.isAttackableMonster((Entity)entity) || animal) {
            List<Scarecrow> scarecrows = ScarecrowTracker.getScarecrowsInRange(level, entity.blockPosition());
            Iterator<Scarecrow> iterator = scarecrows.iterator();
            while (iterator.hasNext()) {
                Predicate filter = arg_0 -> SpawnHandler.lambda$onCheckSpawn$0((Entity)entity, arg_0);
                Scarecrow scarecrow = iterator.next();
                if (!filter.apply((Object)scarecrow) || !(entity.distanceTo((Entity)scarecrow) <= (float)scarecrow.getScarecrowType().getRange()) || !entity.hasLineOfSight((Entity)scarecrow)) continue;
                if (!animal || scarecrow.getScarecrowType().shouldScareAnimals()) {
                    event.setSpawnCancelled(true);
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && (EntityUtil.isAttackableMonster((Entity)(mob = (Mob)entity)) || EntityUtil.isAttackableAnimal((Entity)mob))) {
            mob.goalSelector.addGoal(0, (Goal)new RunAwayGoal(mob));
        }
    }

    private static /* synthetic */ boolean lambda$onCheckSpawn$0(Entity entity, Entity e) {
        return e.isAlive() && ((Mob)entity).getSensing().hasLineOfSight(e);
    }
}

