/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.renderer;

import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.ScarecrowsClient;
import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import bl4ckscor3.mod.scarecrows.renderer.ScarecrowEntityRenderState;
import bl4ckscor3.mod.scarecrows.type.ScarecrowType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class ScarecrowRenderer
extends EntityRenderer<Scarecrow, ScarecrowEntityRenderState> {
    protected static final Map<String, RenderInfo> RENDER_INFO = new HashMap<String, RenderInfo>();

    public ScarecrowRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        RENDER_INFO.clear();
        for (ScarecrowType type : Scarecrows.TYPES) {
            ScarecrowsClient.ClientType clientType = ScarecrowsClient.CLIENT_TYPES.get(type);
            RENDER_INFO.put(type.getName(), new RenderInfo(Identifier.fromNamespaceAndPath((String)"scarecrows", (String)("textures/entity/" + type.getName() + ".png")), clientType.modelGetter().apply(ctx.bakeLayer(clientType.modelLayerLocationGetter().apply(false))), clientType.modelGetter().apply(ctx.bakeLayer(clientType.modelLayerLocationGetter().apply(true)))));
        }
    }

    public void submit(ScarecrowEntityRenderState renderState, PoseStack stack, SubmitNodeCollector submitNodeCollector, CameraRenderState camera) {
        stack.translate(0.0, 1.5, 0.0);
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.rotation));
        submitNodeCollector.submitModel(renderState.model, (Object)renderState, stack, RenderTypes.entitySolid((Identifier)renderState.texture), renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, null, renderState.outlineColor, null);
    }

    public ScarecrowEntityRenderState createRenderState() {
        return new ScarecrowEntityRenderState();
    }

    public void extractRenderState(Scarecrow entity, ScarecrowEntityRenderState renderState, float partialTicks) {
        RenderInfo info = RENDER_INFO.get(entity.getScarecrowType().getName());
        renderState.rotation = entity.getRotation().floatValue();
        renderState.model = entity.isLit() ? info.litModel() : info.unLitModel();
        renderState.texture = info.textureLocation();
        super.extractRenderState((Entity)entity, (EntityRenderState)renderState, partialTicks);
    }

    private record RenderInfo(Identifier textureLocation, EntityModel<ScarecrowEntityRenderState> unLitModel, EntityModel<ScarecrowEntityRenderState> litModel) {
    }
}

