/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.squid.Squid;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityUtil {
    private EntityUtil() {
    }

    public static boolean isAttackableMonster(Entity entity) {
        return entity instanceof Monster || entity instanceof EnderDragon || entity instanceof Ghast || entity instanceof Shulker || entity instanceof Slime;
    }

    public static boolean isAttackableAnimal(Entity entity) {
        return entity instanceof AmbientCreature || entity instanceof Animal || entity instanceof Squid;
    }

    public static Vec3 generateRandomPos(Mob entity, int xz, int y, @Nullable Vec3 target, boolean b) {
        PathNavigation pathnavigate = entity.getNavigation();
        RandomSource random = entity.getRandom();
        boolean flag1 = false;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            BlockPos blockpos1;
            int l = random.nextInt(2 * xz + 1) - xz;
            int i1 = random.nextInt(2 * y + 1) - y;
            int j1 = random.nextInt(2 * xz + 1) - xz;
            if (target != null && !((double)l * target.x + (double)j1 * target.z >= 0.0) || !pathnavigate.isStableDestination(blockpos1 = BlockPos.containing((double)((double)l + entity.getX()), (double)((double)i1 + entity.getY()), (double)((double)j1 + entity.getZ()))) || !b && EntityUtil.isWaterDestination(blockpos1 = EntityUtil.moveAboveSolid(blockpos1, entity), entity)) continue;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3((double)k1 + entity.getX(), (double)i + entity.getY(), (double)j + entity.getZ());
        }
        return null;
    }

    private static BlockPos moveAboveSolid(BlockPos pos, Mob entity) {
        Level level = entity.level();
        if (!level.getBlockState(pos).isSolid()) {
            return pos;
        }
        BlockPos blockpos = pos.above();
        while (blockpos.getY() <= level.getMaxY() && level.getBlockState(blockpos).isSolid()) {
            blockpos = blockpos.above();
        }
        return blockpos;
    }

    private static boolean isWaterDestination(BlockPos pos, Mob entity) {
        return entity.level().getFluidState(pos).is(FluidTags.WATER);
    }
}

