/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.durabilitytooltip;

import com.supermartijn642.durabilitytooltip.DurabilityTooltip;
import com.supermartijn642.durabilitytooltip.DurabilityTooltipConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class DurabilityTooltipClient {
    private static String lastBlackListConfig = "";
    private static Set<String> blackListedMods = new HashSet<String>();

    public static boolean isBlackListed(Item item) {
        String owningMod = BuiltInRegistries.ITEM.getKey((Object)item).getNamespace();
        if (!DurabilityTooltipConfig.blackListedMods.get().equals(lastBlackListConfig)) {
            blackListedMods.clear();
            Arrays.stream(DurabilityTooltipConfig.blackListedMods.get().split(",")).map(String::trim).filter(s -> {
                boolean valid = s.matches("[a-z0-9_.-]+");
                if (!valid) {
                    DurabilityTooltip.LOGGER.error("Invalid modid '" + s + "' in config value 'blackListedMods'!");
                }
                return valid;
            }).forEach(blackListedMods::add);
            lastBlackListConfig = DurabilityTooltipConfig.blackListedMods.get();
        }
        return blackListedMods.contains(owningMod);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent e) {
        if (!(DurabilityTooltipConfig.onlyVanillaTools.get().booleanValue() && !BuiltInRegistries.ITEM.getKey((Object)e.getItemStack().getItem()).getNamespace().equals("minecraft") || DurabilityTooltipClient.isBlackListed(e.getItemStack().getItem()) || !DurabilityTooltipConfig.showWhenFull.get().booleanValue() && !e.getItemStack().isDamaged() || !e.getItemStack().isDamageableItem() || e.getFlags().isAdvanced() && e.getItemStack().isDamaged())) {
            int maxDurability = e.getItemStack().getMaxDamage();
            int durability = maxDurability - e.getItemStack().getDamageValue();
            DurabilityTooltipConfig.tooltipStyle.get().appendTooltip(e.getToolTip(), durability, maxDurability);
        }
    }
}

