/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.IdentifierArgument;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.PermissionCheck;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.commands.arguments.CategoryArgumentType;
import net.puffish.skillsmod.util.CommandUtils;
import net.puffish.skillsmod.util.PointSources;

public class PointsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"points").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(Commands.literal((String)"add").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).then(((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(PointsCommand::addTotal)).then(Commands.argument((String)"source", (ArgumentType)IdentifierArgument.id()).executes(PointsCommand::add))))))).then(Commands.literal((String)"set").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).then(((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(PointsCommand::setTotal)).then(Commands.argument((String)"source", (ArgumentType)IdentifierArgument.id()).executes(PointsCommand::set))))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(PointsCommand::getTotal)).then(Commands.argument((String)"source", (ArgumentType)IdentifierArgument.id()).executes(PointsCommand::get)))));
    }

    private static int add(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        Identifier source = IdentifierArgument.getId(context, (String)"source");
        for (ServerPlayer player : players) {
            category.addPoints(player, source, count);
        }
        CommandUtils.sendSuccess(context, players, "points.add", count, category.getId());
        return players.size();
    }

    private static int set(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        Identifier source = IdentifierArgument.getId(context, (String)"source");
        for (ServerPlayer player : players) {
            category.setPoints(player, source, count);
        }
        CommandUtils.sendSuccess(context, players, "points.set", count, category.getId());
        return players.size();
    }

    private static int get(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        Category category = CategoryArgumentType.getCategory(context, "category");
        Identifier source = IdentifierArgument.getId(context, (String)"source");
        int count = category.getPoints(player, source);
        CommandUtils.sendSuccess(context, player, "points.get", count, category.getId());
        return count;
    }

    private static int addTotal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        for (ServerPlayer player : players) {
            category.addPoints(player, PointSources.COMMANDS, count);
        }
        CommandUtils.sendSuccess(context, players, "points.add", count, category.getId());
        return players.size();
    }

    private static int setTotal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        for (ServerPlayer player : players) {
            category.addPoints(player, PointSources.COMMANDS, count - category.getPointsTotal(player));
        }
        CommandUtils.sendSuccess(context, players, "points.set", count, category.getId());
        return players.size();
    }

    private static int getTotal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        Category category = CategoryArgumentType.getCategory(context, "category");
        int count = category.getPointsTotal(player);
        CommandUtils.sendSuccess(context, player, "points.get", count, category.getId());
        return count;
    }
}

