/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.json.JsonArray;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.skill.SkillsConfig;

public record SkillConnectionConfig(String skillAId, String skillBId) {
    public static Result<Optional<SkillConnectionConfig>, Problem> parse(JsonElement rootElement, SkillsConfig skills) {
        return rootElement.getAsArray().andThen(rootArray -> SkillConnectionConfig.parse(rootArray, skills));
    }

    private static Result<Optional<SkillConnectionConfig>, Problem> parse(JsonArray rootArray, SkillsConfig skills) {
        if (rootArray.getSize() != 2) {
            return Result.failure(rootArray.getPath().createProblem("Expected an array of 2 elements"));
        }
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optIds = rootArray.getAsList((i, element) -> element.getAsString().andThen(skillId -> {
            if (skills.isValid((String)skillId)) {
                return Result.success(skillId);
            }
            return Result.failure(element.getPath().createProblem("Expected a valid skill"));
        })).ifFailure(problems::addAll).getSuccess();
        if (problems.isEmpty()) {
            List ids = optIds.orElseThrow();
            String skillAId = (String)ids.get(0);
            String skillBId = (String)ids.get(1);
            if (skills.isLoaded(skillAId) && skills.isLoaded(skillBId)) {
                return Result.success(Optional.of(new SkillConnectionConfig(skillAId, skillBId)));
            }
            return Result.success(Optional.empty());
        }
        return Result.failure(Problem.combine(problems));
    }
}

