/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.source.builtin;

import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceDisposeContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.calculation.LegacyCalculation;
import net.puffish.skillsmod.calculation.operation.LegacyOperationRegistry;
import net.puffish.skillsmod.calculation.operation.builtin.AttributeOperation;
import net.puffish.skillsmod.calculation.operation.builtin.EffectOperation;
import net.puffish.skillsmod.calculation.operation.builtin.ItemStackCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyItemTagCondition;

public record CraftItemExperienceSource(Calculation<Data> calculation) implements ExperienceSource
{
    private static final Identifier ID = SkillsMod.createIdentifier("craft_item");
    private static final Prototype<Data> PROTOTYPE = Prototype.create(ID);

    public static void register() {
        SkillsAPI.registerExperienceSource(ID, CraftItemExperienceSource::parse);
    }

    private static Result<CraftItemExperienceSource, Problem> parse(ExperienceSourceConfigContext context) {
        return context.getData().andThen(rootElement -> LegacyCalculation.parse(rootElement, PROTOTYPE, (ConfigContext)context).mapSuccess(CraftItemExperienceSource::new));
    }

    @Override
    public void dispose(ExperienceSourceDisposeContext context) {
    }

    static {
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_player"), BuiltinPrototypes.PLAYER, OperationFactory.create(Data::player));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_crafted_item_stack"), BuiltinPrototypes.ITEM_STACK, OperationFactory.create(Data::itemStack));
        LegacyOperationRegistry<Data> legacy = new LegacyOperationRegistry<Data>(PROTOTYPE);
        legacy.registerBooleanFunction("item", ItemStackCondition::parse, Data::itemStack);
        legacy.registerBooleanFunction("item_nbt", ItemStackCondition::parse, Data::itemStack);
        legacy.registerBooleanFunction("item_tag", LegacyItemTagCondition::parse, Data::itemStack);
        legacy.registerNumberFunction("player_effect", effect -> effect.getAmplifier() + 1, EffectOperation::parse, Data::player);
        legacy.registerNumberFunction("player_attribute", AttributeInstance::getValue, AttributeOperation::parse, Data::player);
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("player"), SkillsMod.createIdentifier("get_player"));
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("crafted_item_stack"), SkillsMod.createIdentifier("get_crafted_item_stack"));
    }

    public record Data(ServerPlayer player, ItemStack itemStack) {
    }
}

