/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Experience;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.impl.ExperienceImpl;
import net.puffish.skillsmod.impl.SkillImpl;
import net.puffish.skillsmod.util.PointSources;

public class CategoryImpl
implements Category {
    private final Identifier categoryId;

    public CategoryImpl(Identifier categoryId) {
        this.categoryId = categoryId;
    }

    @Override
    public Identifier getId() {
        return this.categoryId;
    }

    @Override
    public Optional<Experience> getExperience() {
        if (SkillsMod.getInstance().hasExperience(this.categoryId).orElseThrow().booleanValue()) {
            return Optional.of(new ExperienceImpl(this.categoryId));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Skill> getSkill(String skillId) {
        if (SkillsMod.getInstance().hasSkill(this.categoryId, skillId)) {
            return Optional.of(new SkillImpl(this, skillId));
        }
        return Optional.empty();
    }

    @Override
    public Stream<Skill> streamSkills() {
        return SkillsMod.getInstance().getSkills(this.categoryId).orElseThrow().stream().map(skillId -> new SkillImpl(this, (String)skillId));
    }

    @Override
    public Stream<Skill> streamUnlockedSkills(ServerPlayer player) {
        return SkillsMod.getInstance().getUnlockedSkills(player, this.categoryId).orElseThrow().stream().map(skillId -> new SkillImpl(this, (String)skillId));
    }

    @Override
    public void openScreen(ServerPlayer player) {
        SkillsMod.getInstance().openScreen(player, Optional.of(this.categoryId));
    }

    @Override
    public void unlock(ServerPlayer player) {
        SkillsMod.getInstance().unlockCategory(player, this.categoryId);
    }

    @Override
    public void lock(ServerPlayer player) {
        SkillsMod.getInstance().lockCategory(player, this.categoryId);
    }

    @Override
    public boolean isUnlocked(ServerPlayer player) {
        return SkillsMod.getInstance().isCategoryUnlocked(player, this.categoryId).orElseThrow();
    }

    @Override
    public void erase(ServerPlayer player) {
        SkillsMod.getInstance().eraseCategory(player, this.categoryId);
    }

    @Override
    public void resetSkills(ServerPlayer player) {
        SkillsMod.getInstance().resetSkills(player, this.categoryId);
    }

    @Override
    public Stream<Identifier> streamPointsSources(ServerPlayer player) {
        return SkillsMod.getInstance().getPointsSources(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getPoints(ServerPlayer player, Identifier source) {
        return SkillsMod.getInstance().getPoints(player, this.categoryId, source).orElseThrow();
    }

    @Override
    public void setPoints(ServerPlayer player, Identifier source, int count) {
        SkillsMod.getInstance().setPoints(player, this.categoryId, source, count, false);
    }

    @Override
    public void addPoints(ServerPlayer player, Identifier source, int count) {
        SkillsMod.getInstance().addPoints(player, this.categoryId, source, count, false);
    }

    @Override
    public void setPointsSilently(ServerPlayer player, Identifier source, int count) {
        SkillsMod.getInstance().setPoints(player, this.categoryId, source, count, true);
    }

    @Override
    public void addPointsSilently(ServerPlayer player, Identifier source, int count) {
        SkillsMod.getInstance().addPoints(player, this.categoryId, source, count, true);
    }

    @Override
    public int getSpentPoints(ServerPlayer player) {
        return SkillsMod.getInstance().getSpentPoints(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getPointsTotal(ServerPlayer player) {
        return SkillsMod.getInstance().getPointsTotal(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getPointsLeft(ServerPlayer player) {
        return SkillsMod.getInstance().getPointsLeft(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getExtraPoints(ServerPlayer player) {
        return this.getPointsTotal(player);
    }

    @Override
    public void setExtraPoints(ServerPlayer player, int count) {
        this.addExtraPoints(player, count - this.getExtraPoints(player));
    }

    @Override
    public void addExtraPoints(ServerPlayer player, int count) {
        this.addPoints(player, PointSources.COMMANDS, count);
    }
}

