/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.reward.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import org.apache.commons.lang3.RandomStringUtils;

public class PointsReward
implements Reward {
    public static final Identifier ID = SkillsMod.createIdentifier("points");
    private static final String PREFIX = "points_reward.";
    private final Identifier categoryId;
    private final int points;
    private final Identifier source;

    private PointsReward(Identifier categoryId, int points, Identifier source) {
        this.categoryId = categoryId;
        this.points = points;
        this.source = source;
    }

    public static void register() {
        SkillsAPI.registerReward(ID, PointsReward::parse);
    }

    private static Result<PointsReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(rootObject -> rootObject.noUnused(PointsReward::parse));
    }

    private static Result<PointsReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optCategory = rootObject.get("category").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
        Optional<Integer> optPoints = rootObject.getInt("points").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new PointsReward((Identifier)optCategory.orElseThrow(), optPoints.orElseThrow(), SkillsMod.createIdentifier(PREFIX + RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789"))));
        }
        return Result.failure(Problem.combine(problems));
    }

    public static void cleanup(ServerPlayer player) {
        SkillsAPI.streamCategories().forEach(category -> {
            List<Identifier> sources = category.streamPointsSources(player).filter(source -> source.getNamespace().equals("puffish_skills")).filter(source -> source.getPath().startsWith(PREFIX)).toList();
            for (Identifier source2 : sources) {
                category.setPoints(player, source2, 0);
            }
        });
    }

    @Override
    public void update(RewardUpdateContext context) {
        SkillsAPI.getCategory(this.categoryId).ifPresent(category -> {
            if (context.isAction()) {
                category.setPoints(context.getPlayer(), this.source, this.points * context.getCount());
            } else {
                category.setPointsSilently(context.getPlayer(), this.source, this.points * context.getCount());
            }
        });
    }

    @Override
    public void dispose(RewardDisposeContext context) {
        SkillsAPI.getCategory(this.categoryId).ifPresent(category -> context.getServer().getPlayerList().getPlayers().forEach(player -> category.setPoints((ServerPlayer)player, this.source, 0)));
    }
}

