/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mvs.world.structures.pieces;

import com.finndog.mvs.MVSCommon;
import com.finndog.mvs.misc.structurepiececounter.StructurePieceCountsManager;
import com.finndog.mvs.mixins.structures.SinglePoolElementAccessor;
import com.finndog.mvs.mixins.structures.StructurePoolAccessor;
import com.finndog.mvs.utils.BoxOctree;
import com.finndog.mvs.utils.GeneralUtils;
import com.finndog.mvs.world.structures.GenericJigsawStructure;
import com.finndog.mvs.world.structures.pieces.LegacyOceanBottomSinglePoolElement;
import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableObject;

public class PieceLimitedJigsawManager {
    public static Optional<Structure.GenerationStub> assembleJigsawStructure(Structure.GenerationContext context, Holder<StructureTemplatePool> startPoolHolder, int size, ResourceLocation structureID, BlockPos startPos, boolean doBoundaryAdjustments, Optional<Heightmap.Types> heightmapType, int maxY, int minY, Set<ResourceLocation> poolsThatIgnoreBounds, Optional<Integer> maxDistanceFromCenter, Optional<GenericJigsawStructure.BURYING_TYPE> buryingType, LiquidSettings liquidSettings, BiConsumer<StructurePiecesBuilder, List<PoolElementStructurePiece>> structureBoundsAdjuster) {
        Registry jigsawPoolRegistry = context.registryAccess().lookupOrThrow(Registries.TEMPLATE_POOL);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
        Rotation rotation = Rotation.getRandom((RandomSource)random);
        StructureTemplatePool startPool = (StructureTemplatePool)startPoolHolder.value();
        if (startPool.size() == 0) {
            MVSCommon.LOGGER.warn("Moog's Voyager Structures: Empty or nonexistent start pool in structure: {}  Crash is imminent", (Object)structureID);
            throw new RuntimeException("Moog's Voyager Structures: Empty or nonexistent start pool in structure: " + String.valueOf(structureID) + " Crash is imminent");
        }
        StructurePoolElement startPieceBlueprint = startPool.getRandomTemplate((RandomSource)random);
        if (startPieceBlueprint == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        PoolElementStructurePiece startPiece = new PoolElementStructurePiece(context.structureTemplateManager(), startPieceBlueprint, startPos, startPieceBlueprint.getGroundLevelDelta(), rotation, startPieceBlueprint.getBoundingBox(context.structureTemplateManager(), startPos, rotation), liquidSettings);
        BoundingBox pieceBoundingBox = startPiece.getBoundingBox();
        int pieceCenterX = (pieceBoundingBox.maxX() + pieceBoundingBox.minX()) / 2;
        int pieceCenterZ = (pieceBoundingBox.maxZ() + pieceBoundingBox.minZ()) / 2;
        int pieceCenterY = heightmapType.map(types -> startPos.getY() + context.chunkGenerator().getFirstFreeHeight(pieceCenterX, pieceCenterZ, types, context.heightAccessor(), context.randomState())).orElseGet(() -> ((BlockPos)startPos).getY());
        if (heightmapType.isPresent() && (pieceCenterY > maxY || pieceCenterY < minY)) {
            return Optional.empty();
        }
        int yAdjustment = pieceBoundingBox.minY() + startPiece.getGroundLevelDelta();
        startPiece.move(0, pieceCenterY - yAdjustment, 0);
        if (!context.validBiome().test(context.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)pieceCenterX), QuartPos.fromBlock((int)pieceCenterY), QuartPos.fromBlock((int)pieceCenterZ), context.randomState().sampler()))) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(new BlockPos(pieceCenterX, pieceCenterY, pieceCenterZ), structurePiecesBuilder -> {
            ArrayList<PoolElementStructurePiece> components = new ArrayList<PoolElementStructurePiece>();
            components.add(startPiece);
            Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces = StructurePieceCountsManager.STRUCTURE_PIECE_COUNTS_MANAGER.getRequirePieces(structureID);
            boolean runOnce = requiredPieces == null || requiredPieces.isEmpty();
            HashMap<ResourceLocation, Integer> currentPieceCounter = new HashMap<ResourceLocation, Integer>();
            int attempts = 0;
            while (runOnce || PieceLimitedJigsawManager.doesNotHaveAllRequiredPieces(components, requiredPieces, currentPieceCounter)) {
                if (attempts == 100) {
                    MVSCommon.LOGGER.error("\n-------------------------------------------------------------------\nMoog's Voyager Structures: Failed to create valid structure with all required pieces starting from this pool file: {}. Required pieces failed to generate the required amount are: {}\n  This can happen if a structure has a required piece but the structure size is set too low.\n  However, this is most likely caused by a structure unable to spawn properly due to hitting the world's min y or max y build thresholds or a broken MVS datapack.\n  Try teleporting to: {} and see if the structure generated fine with the required structure piece or if it is indeed missing it.\n  Please report the issue to Moog's Voyager Structures' dev with latest.log file if the structure is not cut off by world min/max y build thresholds.\n\n", (Object)jigsawPoolRegistry.getKey((Object)startPool), (Object)Arrays.toString(currentPieceCounter.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).toArray()), (Object)new BlockPos(pieceCenterX, pieceCenterY, pieceCenterZ));
                    break;
                }
                PoolElementStructurePiece startPieceToUse = startPiece;
                if (attempts > 0) {
                    StructurePoolElement startPieceBlueprintNew = startPool.getRandomTemplate((RandomSource)random);
                    startPieceToUse = new PoolElementStructurePiece(context.structureTemplateManager(), startPieceBlueprintNew, startPiece.getPosition(), startPieceBlueprintNew.getGroundLevelDelta(), startPiece.getRotation(), startPieceBlueprintNew.getBoundingBox(context.structureTemplateManager(), startPiece.getPosition(), startPiece.getRotation()), liquidSettings);
                }
                components.clear();
                components.add(startPiece);
                if (size > 0) {
                    int boxRange = maxDistanceFromCenter.orElse(80);
                    AABB axisAlignedBB = new AABB((double)(pieceCenterX - boxRange), (double)(pieceCenterY - 120), (double)(pieceCenterZ - boxRange), (double)(pieceCenterX + boxRange + 1), (double)(pieceCenterY + 180 + 1), (double)(pieceCenterZ + boxRange + 1));
                    BoxOctree boxOctree = new BoxOctree(axisAlignedBB);
                    boxOctree.addBox(AABB.of((BoundingBox)pieceBoundingBox));
                    Entry startPieceEntry = new Entry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)boxOctree), pieceCenterY + 80, 0);
                    Assembler assembler = new Assembler(structureID, (Registry<StructureTemplatePool>)jigsawPoolRegistry, size, context, components, (RandomSource)random, requiredPieces, buryingType.isEmpty() ? maxY : Integer.MAX_VALUE, buryingType.isEmpty() ? minY : Integer.MIN_VALUE, poolsThatIgnoreBounds, liquidSettings);
                    assembler.availablePieces.addLast(startPieceEntry);
                    while (!assembler.availablePieces.isEmpty()) {
                        Entry entry2 = assembler.availablePieces.removeFirst();
                        assembler.generatePiece(entry2.piece, entry2.boxOctreeMutableObject, entry2.topYLimit, entry2.depth, doBoundaryAdjustments, context.heightAccessor());
                    }
                }
                if (runOnce) break;
                ++attempts;
            }
            components.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).addPiece(arg_0));
            structureBoundsAdjuster.accept((StructurePiecesBuilder)structurePiecesBuilder, (List<PoolElementStructurePiece>)components);
            if (structurePiecesBuilder.getBoundingBox().maxY() > context.heightAccessor().getMaxY()) {
                structurePiecesBuilder.clear();
            }
        }));
    }

    private static boolean doesNotHaveAllRequiredPieces(List<? extends StructurePiece> components, Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces, Map<ResourceLocation, Integer> counter) {
        counter.clear();
        requiredPieces.forEach((key, value) -> counter.put((ResourceLocation)key, value.getRequiredAmount()));
        for (StructurePiece structurePiece : components) {
            ResourceLocation pieceID;
            StructurePoolElement poolElement;
            if (!(structurePiece instanceof PoolElementStructurePiece) || !((poolElement = ((PoolElementStructurePiece)structurePiece).getElement()) instanceof SinglePoolElement) || !counter.containsKey(pieceID = (ResourceLocation)((SinglePoolElementAccessor)poolElement).mvs_getTemplate().left().orElse(null))) continue;
            counter.put(pieceID, counter.get(pieceID) - 1);
        }
        return counter.values().stream().anyMatch(count -> count > 0);
    }

    public record Entry(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctreeMutableObject, int topYLimit, int depth) {
    }

    public static final class Assembler {
        private final Registry<StructureTemplatePool> poolRegistry;
        private final int maxDepth;
        private final Structure.GenerationContext context;
        private final List<? super PoolElementStructurePiece> structurePieces;
        private final RandomSource random;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();
        private final Map<ResourceLocation, Integer> currentPieceCounts;
        private final Map<ResourceLocation, Integer> maximumPieceCounts;
        private final Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces;
        private final int maxY;
        private final int minY;
        private final Set<ResourceLocation> poolsThatIgnoreBounds;
        private final LiquidSettings liquidSettings;

        public Assembler(ResourceLocation structureID, Registry<StructureTemplatePool> poolRegistry, int maxDepth, Structure.GenerationContext context, List<? super PoolElementStructurePiece> structurePieces, RandomSource random, Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces, int maxY, int minY, Set<ResourceLocation> poolsThatIgnoreBounds, LiquidSettings liquidSettings) {
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.context = context;
            this.structurePieces = structurePieces;
            this.random = random;
            this.maxY = maxY;
            this.minY = minY;
            this.requiredPieces = requiredPieces == null ? new HashMap<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds>() : new HashMap<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds>(requiredPieces);
            this.maximumPieceCounts = new HashMap<ResourceLocation, Integer>(StructurePieceCountsManager.STRUCTURE_PIECE_COUNTS_MANAGER.getMaximumCountForPieces(structureID));
            this.poolsThatIgnoreBounds = poolsThatIgnoreBounds;
            this.liquidSettings = liquidSettings;
            this.currentPieceCounts = new HashMap<ResourceLocation, Integer>();
            this.requiredPieces.forEach((key, value) -> this.currentPieceCounts.putIfAbsent((ResourceLocation)key, 0));
            this.maximumPieceCounts.forEach((key, value) -> this.currentPieceCounts.putIfAbsent((ResourceLocation)key, 0));
        }

        public void generatePiece(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctree, int minY, int depth, boolean doBoundaryAdjustments, LevelHeightAccessor heightLimitView) {
            StructurePoolElement pieceBlueprint = piece.getElement();
            BlockPos piecePos = piece.getPosition();
            Rotation pieceRotation = piece.getRotation();
            BoundingBox pieceBoundingBox = piece.getBoundingBox();
            int pieceMinY = pieceBoundingBox.minY();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            List pieceJigsawBlocks = pieceBlueprint.getShuffledJigsawBlocks(this.context.structureTemplateManager(), piecePos, pieceRotation, this.random);
            for (StructureTemplate.JigsawBlockInfo jigsawBlock : pieceJigsawBlocks) {
                StructurePoolElement generatedPiece;
                int targetPieceBoundsTop;
                MutableObject<BoxOctree> octreeToUse;
                Direction direction = JigsawBlock.getFrontFacing((BlockState)jigsawBlock.info().state());
                BlockPos jigsawBlockPos = jigsawBlock.info().pos();
                BlockPos jigsawBlockTargetPos = jigsawBlockPos.relative(direction);
                ResourceLocation jigsawBlockPool = ResourceLocation.tryParse((String)jigsawBlock.info().nbt().getString("pool"));
                Optional poolOptional = this.poolRegistry.getOptional(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((StructureTemplatePool)poolOptional.get()).size() == 0 && !Objects.equals(jigsawBlockPool, Pools.EMPTY.location())) {
                    MVSCommon.LOGGER.warn("Moog's Voyager Structures: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockPool, pieceBlueprint instanceof SinglePoolElement ? ((SinglePoolElementAccessor)pieceBlueprint).mvs_getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                Holder jigsawBlockFallback = ((StructureTemplatePool)poolOptional.get()).getFallback();
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.isInside((Vec3i)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    octreeToUse = parentOctree;
                    targetPieceBoundsTop = pieceMinY;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(AABB.of((BoundingBox)pieceBoundingBox)));
                    }
                } else {
                    octreeToUse = boxOctree;
                    targetPieceBoundsTop = minY;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)poolOptional.get()).mvs_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, false)) != null) continue;
                boolean ignoreBounds = false;
                if (this.poolsThatIgnoreBounds != null) {
                    ResourceLocation fallBackPoolRL = this.poolRegistry.getKey((Object)((StructureTemplatePool)jigsawBlockFallback.value()));
                    ignoreBounds = this.poolsThatIgnoreBounds.contains(fallBackPoolRL);
                }
                this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)jigsawBlockFallback.value()).mvs_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, ignoreBounds);
            }
        }

        private StructurePoolElement processList(List<Pair<StructurePoolElement, Integer>> candidatePieces, boolean doBoundaryAdjustments, StructureTemplate.JigsawBlockInfo jigsawBlock, BlockPos jigsawBlockTargetPos, int pieceMinY, BlockPos jigsawBlockPos, MutableObject<BoxOctree> boxOctreeMutableObject, PoolElementStructurePiece piece, int depth, int targetPieceBoundsTop, LevelHeightAccessor heightLimitView, boolean ignoreBounds) {
            StructureTemplatePool.Projection piecePlacementBehavior = piece.getElement().getProjection();
            boolean isPieceRigid = piecePlacementBehavior == StructureTemplatePool.Projection.RIGID;
            boolean isPieceOceanFloor = piece.getElement() instanceof LegacyOceanBottomSinglePoolElement;
            int jigsawBlockRelativeY = jigsawBlockPos.getY() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                StructurePoolElement candidatePiece;
                Object chosenPiecePair = null;
                Optional<ResourceLocation> pieceNeededToSpawn = this.requiredPieces.keySet().stream().filter(key -> {
                    int currentCount = this.currentPieceCounts.get(key);
                    StructurePieceCountsManager.RequiredPieceNeeds requiredPieceNeeds = this.requiredPieces.get(key);
                    int requireCount = requiredPieceNeeds == null ? 0 : requiredPieceNeeds.getRequiredAmount();
                    return currentCount < requireCount;
                }).findFirst();
                if (pieceNeededToSpawn.isPresent()) {
                    for (int i = 0; i < candidatePieces.size(); ++i) {
                        Pair<StructurePoolElement, Integer> candidatePiecePair = candidatePieces.get(i);
                        StructurePoolElement structurePoolElement = (StructurePoolElement)candidatePiecePair.getFirst();
                        if (!(structurePoolElement instanceof SinglePoolElement) || !((ResourceLocation)((SinglePoolElementAccessor)structurePoolElement).mvs_getTemplate().left().get()).equals((Object)pieceNeededToSpawn.get())) continue;
                        if (depth >= Math.min(this.maxDepth - 1, this.requiredPieces.get(pieceNeededToSpawn.get()).getMinDistanceFromCenter())) {
                            chosenPiecePair = candidatePiecePair;
                            break;
                        }
                        totalCount -= ((Integer)candidatePiecePair.getSecond()).intValue();
                        candidatePieces.remove(candidatePiecePair);
                        break;
                    }
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.random.nextInt(totalCount) + 1;
                    for (Pair pair : candidatePieces) {
                        if ((chosenWeight -= ((Integer)pair.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = pair;
                        break;
                    }
                }
                if ((candidatePiece = (StructurePoolElement)chosenPiecePair.getFirst()) == EmptyPoolElement.INSTANCE) {
                    return null;
                }
                ResourceLocation pieceName = null;
                if (candidatePiece instanceof SinglePoolElement && this.currentPieceCounts.containsKey(pieceName = (ResourceLocation)((SinglePoolElementAccessor)candidatePiece).mvs_getTemplate().left().get()) && this.maximumPieceCounts.containsKey(pieceName) && this.currentPieceCounts.get(pieceName) >= this.maximumPieceCounts.get(pieceName)) {
                    totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (Rotation rotation : Rotation.getShuffled((RandomSource)this.random)) {
                    List candidateJigsawBlocks = candidatePiece.getShuffledJigsawBlocks(this.context.structureTemplateManager(), BlockPos.ZERO, rotation, this.random);
                    BoundingBox tempCandidateBoundingBox = candidatePiece.getBoundingBox(this.context.structureTemplateManager(), BlockPos.ZERO, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.getYSpan() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.isInside((Vec3i)pieceCandidateJigsawBlock.info().pos().relative(JigsawBlock.getFrontFacing((BlockState)pieceCandidateJigsawBlock.info().state())))) {
                            return 0;
                        }
                        ResourceLocation candidateTargetPool = ResourceLocation.tryParse((String)pieceCandidateJigsawBlock.info().nbt().getString("pool"));
                        Optional candidateTargetPoolOptional = this.poolRegistry.getOptional(candidateTargetPool);
                        if (candidateTargetPoolOptional.isEmpty()) {
                            MVSCommon.LOGGER.warn("Moog's Voyager Structures: Non-existent child pool attempted to be spawned: {} which is being called from {}. Let Moog's Voyager Structures dev (FinnDog) know about this log entry.", (Object)candidateTargetPool, candidatePiece instanceof SinglePoolElement ? ((SinglePoolElementAccessor)candidatePiece).mvs_getTemplate().left().get() : "not a SinglePoolElement class");
                        }
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetPoolOptional.map(c -> ((StructureTemplatePool)c.getFallback().value()).getMaxSize(this.context.structureTemplateManager())).orElse(0);
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(c -> c.getMaxSize(this.context.structureTemplateManager())).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.JigsawBlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!GeneralUtils.canJigsawsAttach(jigsawBlock, candidateJigsawBlock)) continue;
                        BlockPos candidateJigsawBlockPos = candidateJigsawBlock.info().pos();
                        BlockPos candidateJigsawBlockRelativePos = new BlockPos(jigsawBlockTargetPos.getX() - candidateJigsawBlockPos.getX(), jigsawBlockTargetPos.getY() - candidateJigsawBlockPos.getY(), jigsawBlockTargetPos.getZ() - candidateJigsawBlockPos.getZ());
                        BoundingBox candidateBoundingBox = candidatePiece.getBoundingBox(this.context.structureTemplateManager(), candidateJigsawBlockRelativePos, rotation);
                        StructureTemplatePool.Projection candidatePlacementBehavior = candidatePiece.getProjection();
                        boolean isCandidateRigid = candidatePlacementBehavior == StructureTemplatePool.Projection.RIGID;
                        boolean isCandidatePieceOceanFloor = candidatePiece instanceof LegacyOceanBottomSinglePoolElement;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.getY();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.getFrontFacing((BlockState)jigsawBlock.info().state()).getStepY();
                        if (isPieceRigid && !isPieceOceanFloor && isCandidateRigid && !isCandidatePieceOceanFloor) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.context.chunkGenerator().getFirstFreeHeight(jigsawBlockPos.getX(), jigsawBlockPos.getZ(), isCandidatePieceOceanFloor || isPieceOceanFloor ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, this.context.randomState());
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.minY();
                        BoundingBox adjustedCandidateBoundingBox = candidateBoundingBox.moved(0, candidatePieceYOffsetNeeded, 0);
                        BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.offset(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.maxY() - adjustedCandidateBoundingBox.minY());
                            adjustedCandidateBoundingBox.encapsulate(new BlockPos(adjustedCandidateBoundingBox.minX(), adjustedCandidateBoundingBox.minY() + k2, adjustedCandidateBoundingBox.minZ()));
                        }
                        if (adjustedCandidateBoundingBox.maxY() > this.maxY || adjustedCandidateBoundingBox.minY() < this.minY) continue;
                        AABB axisAlignedBB = AABB.of((BoundingBox)adjustedCandidateBoundingBox);
                        AABB axisAlignedBBDeflated = axisAlignedBB.deflate(0.25);
                        boolean validBounds = false;
                        if (ignoreBounds || ((BoxOctree)boxOctreeMutableObject.getValue()).boundaryContains(axisAlignedBBDeflated) && !((BoxOctree)boxOctreeMutableObject.getValue()).intersectsAnyBox(axisAlignedBBDeflated)) {
                            ((BoxOctree)boxOctreeMutableObject.getValue()).addBox(axisAlignedBB);
                            validBounds = true;
                        }
                        if (!validBounds) continue;
                        int newPieceGroundLevelDelta = piece.getGroundLevelDelta();
                        int groundLevelDelta = isCandidateRigid && !isCandidatePieceOceanFloor ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.getGroundLevelDelta();
                        PoolElementStructurePiece newPiece = new PoolElementStructurePiece(this.context.structureTemplateManager(), candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox, this.liquidSettings);
                        if (isPieceRigid && !isPieceOceanFloor) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid && !isCandidatePieceOceanFloor) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.context.chunkGenerator().getFirstFreeHeight(jigsawBlockPos.getX(), jigsawBlockPos.getZ(), isCandidatePieceOceanFloor || isPieceOceanFloor ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, this.context.randomState());
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.addJunction(new JigsawJunction(jigsawBlockTargetPos.getX(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.getZ(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.addJunction(new JigsawJunction(jigsawBlockPos.getX(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.getZ(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((PoolElementStructurePiece)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, boxOctreeMutableObject, targetPieceBoundsTop, depth + 1));
                        }
                        if (pieceName != null && this.currentPieceCounts.containsKey(pieceName)) {
                            this.currentPieceCounts.put(pieceName, this.currentPieceCounts.get(pieceName) + 1);
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

