/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.BrokenAnkh;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class BrokenAnkhEvents {
    @SubscribeEvent
    public static void stopDeath(LivingDeathEvent event) {
        Player player;
        BrokenAnkh.Stats config = (BrokenAnkh.Stats)BrokenAnkh.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).isSpectator()) {
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.BROKEN_ANKH.get());
            if (!stack.isEmpty() && player.isDeadOrDying() && !player.getCooldowns().isOnCooldown(((SlotEntryReference)stack.getFirst()).stack()) && !player.level().isClientSide) {
                ((ServerLevel)player.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, player.getX(), player.getY(), player.getZ(), 100, 1.0, 1.0, 1.0, 0.1);
                ((ServerLevel)player.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, player.getX(), player.getY(), player.getZ(), 50, 1.0, 1.0, 1.0, 0.1);
                ((ServerLevel)player.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, player.getX(), player.getY(), player.getZ(), 100, 1.0, 1.0, 1.0, 0.1);
                event.setCanceled(true);
                player.setHealth(2.0f);
                player.removeAllEffects();
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
                player.getCooldowns().addCooldown(((SlotEntryReference)stack.getFirst()).stack(), config.cooldown);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
        if (accessories == null) {
            return;
        }
        List stack = accessories.getEquipped(ModItems.BROKEN_ANKH.get());
        if (!stack.isEmpty()) {
            player.getCooldowns().addCooldown(((SlotEntryReference)stack.getFirst()).stack(), BrokenAnkh.getCooldown(((SlotEntryReference)stack.getFirst()).stack()));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        BrokenAnkh.Stats config = (BrokenAnkh.Stats)BrokenAnkh.INSTANCE.getTrinketConfig();
        Player player = event.getEntity();
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
        if (accessories == null) {
            return;
        }
        List stack = accessories.getEquipped(ModItems.BROKEN_ANKH.get());
        if (stack.isEmpty()) {
            return;
        }
        BrokenAnkh.setCooldown(((SlotEntryReference)stack.getFirst()).stack(), (int)(player.getCooldowns().getCooldownPercent(((SlotEntryReference)stack.getFirst()).stack(), 0.0f) * (float)config.cooldown));
    }
}

