/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.Callus;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class CallusEvents {
    @SubscribeEvent
    public static void applyCallusDamageReduction(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity;
        Callus.Stats config = (Callus.Stats)Callus.INSTANCE.getTrinketConfig();
        if (!config.isEnable || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
        if (accessories == null) {
            return;
        }
        List stack = accessories.getEquipped(ModItems.CALLUS.get());
        if (stack.isEmpty()) {
            return;
        }
        DamageSource source = event.getSource();
        float newDamage = event.getOriginalDamage();
        newDamage = CallusEvents.isNullifiedDamageType(source) ? 0.0f : (source.is(DamageTypes.FALL) ? (newDamage *= (float)(1.0 - (double)config.fallDamageReductionPercentage / 100.0)) : (newDamage *= (float)(1.0 - (double)config.generalDamageReductionPercentage / 100.0)));
        event.setNewDamage(newDamage);
    }

    private static boolean isNullifiedDamageType(DamageSource source) {
        return source.is(DamageTypes.CACTUS) || source.is(DamageTypes.FALLING_ANVIL) || source.is(DamageTypes.HOT_FLOOR) || source.is(DamageTypes.SWEET_BERRY_BUSH);
    }
}

