/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.ExperienceBattery;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class ExperienceBatteryEvents {
    @SubscribeEvent
    public static void handleExperienceDrop(LivingExperienceDropEvent event) {
        ExperienceBattery.Stats config = (ExperienceBattery.Stats)ExperienceBattery.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        Player attackingPlayer = event.getAttackingPlayer();
        if (attackingPlayer == null) {
            return;
        }
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)attackingPlayer);
        if (accessories == null) {
            return;
        }
        List stack = accessories.getEquipped(ModItems.EXPERIENCE_BATTERY.get());
        if (stack.isEmpty() || event.getEntity() instanceof Player) {
            return;
        }
        float experienceMultiplier = config.experienceMultiplier;
        int originalExperience = event.getOriginalExperience();
        int bonusExperience = (int)((float)originalExperience * experienceMultiplier);
        if (bonusExperience > 0) {
            event.setDroppedExperience(event.getDroppedExperience() + bonusExperience);
        }
    }
}

