/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.ExplosionProofJacket;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class ExplosionProofJacketEvents {
    @SubscribeEvent
    public static void handleExplosionDamageReduction(LivingDamageEvent.Pre event) {
        ExplosionProofJacket.Stats config = (ExplosionProofJacket.Stats)ExplosionProofJacket.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.isSpectator() && event.getEntity() == player) {
            Level world = player.level();
            ItemStack itemStack = Items.TNT.getDefaultInstance();
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.EXPLOSION_PROOF_JACKET.get());
            if (!stack.isEmpty() && event.getSource().is(DamageTypeTags.IS_EXPLOSION)) {
                event.setNewDamage(event.getOriginalDamage() * (1.0f - config.blastDamagePercentageReduction) * 100.0f);
                BlockPos pos = player.blockPosition();
                ItemEntity itementity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemStack);
                itementity.setDefaultPickUpDelay();
                itementity.setInvulnerable(true);
                world.addFreshEntity((Entity)itementity);
            }
        }
    }
}

